/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.telemetry.InfinispanSpanAttributes;
import org.infinispan.telemetry.SpanCategory;
import org.infinispan.telemetry.impl.CacheSpanAttribute;
import org.infinispan.util.KeyValuePair;

public class CacheInfo<K, V> {
    private final Map<KeyValuePair<MediaType, MediaType>, AdvancedCache<K, V>> encodedCaches = new ConcurrentHashMap<KeyValuePair<MediaType, MediaType>, AdvancedCache<K, V>>();
    protected final AdvancedCache<K, V> cache;
    private final InfinispanSpanAttributes attributes;

    public CacheInfo(AdvancedCache<K, V> cache) {
        this.cache = cache;
        this.attributes = ((CacheSpanAttribute)SecurityActions.getCacheComponentRegistry(cache).getComponent(CacheSpanAttribute.class)).getAttributes(SpanCategory.CONTAINER);
    }

    public AdvancedCache<K, V> getCache(KeyValuePair<MediaType, MediaType> mediaTypes, Subject subject) {
        AdvancedCache encodedCache = this.encodedCaches.get(mediaTypes);
        if (encodedCache == null) {
            encodedCache = this.cache.withMediaType((MediaType)mediaTypes.getKey(), (MediaType)mediaTypes.getValue());
            this.encodedCaches.put(mediaTypes, encodedCache);
        }
        if (subject == null) {
            return encodedCache;
        }
        return encodedCache.withSubject(subject);
    }

    public AdvancedCache<K, V> getCache() {
        return this.cache;
    }

    public InfinispanSpanAttributes getInfinispanSpanAttributes() {
        return this.attributes;
    }
}

