/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security.external;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.commons.util.Util;

final class ExternalSaslServer
implements SaslServer {
    private final AtomicBoolean complete = new AtomicBoolean();
    private String authorizationID;
    private final X500Principal peerPrincipal;
    private final CallbackHandler callbackHandler;

    ExternalSaslServer(CallbackHandler callbackHandler, X500Principal peerPrincipal) {
        this.callbackHandler = callbackHandler;
        this.peerPrincipal = peerPrincipal;
    }

    @Override
    public String getMechanismName() {
        return "EXTERNAL";
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (this.complete.getAndSet(true)) {
            throw new SaslException("Received response after complete");
        }
        String userName = new String(response, StandardCharsets.UTF_8);
        if (userName.isEmpty()) {
            userName = this.peerPrincipal.getName();
        }
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(this.peerPrincipal.getName(), userName);
        ExternalSaslServer.handleCallback(this.callbackHandler, authorizeCallback);
        if (!authorizeCallback.isAuthorized()) {
            throw new SaslException("EXTERNAL: " + this.peerPrincipal.getName() + " is not authorized to act as " + userName);
        }
        this.authorizationID = authorizeCallback.getAuthorizedID();
        return Util.EMPTY_BYTE_ARRAY;
    }

    private static void handleCallback(CallbackHandler handler, Callback callback) throws SaslException {
        try {
            handler.handle(new Callback[]{callback});
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SaslException("Failed to authenticate due to callback exception", e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Failed to authenticate due to unsupported callback", e);
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException();
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException();
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if ("org.infinispan.security.Subject".equals(propName)) {
            if (this.isComplete()) {
                Subject subject = new Subject();
                subject.getPrincipals().add(this.peerPrincipal);
                return subject;
            }
            throw new IllegalStateException("Authentication is not complete");
        }
        return null;
    }

    @Override
    public void dispose() throws SaslException {
    }
}

