/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.security.sasl;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.infinispan.server.core.configuration.SaslConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.security.InetAddressPrincipal;

public interface SaslAuthenticator {
    default public SaslServer createSaslServer(String mechanism, List<Principal> principals, String protocol, String serverName, Map<String, String> props) throws SaslException {
        throw new UnsupportedOperationException();
    }

    public static SaslServer createSaslServer(SaslConfiguration configuration, Channel channel, String mech, String protocol) throws Throwable {
        SaslAuthenticator sap = configuration.authenticator();
        return SaslAuthenticator.createSaslServer(sap, configuration, channel, mech, protocol);
    }

    public static SaslServer createSaslServer(SaslAuthenticator sap, SaslConfiguration configuration, Channel channel, String mech, String protocol) throws Throwable {
        ArrayList<Principal> principals;
        block6: {
            principals = new ArrayList<Principal>(2);
            SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
            if (sslHandler != null) {
                try {
                    Principal peerPrincipal = sslHandler.engine().getSession().getPeerPrincipal();
                    principals.add(peerPrincipal);
                }
                catch (SSLPeerUnverifiedException e) {
                    if (!"EXTERNAL".equals(mech)) break block6;
                    throw Log.SECURITY.externalMechNotAllowedWithoutSSLClientCert();
                }
            }
        }
        principals.add(new InetAddressPrincipal(((InetSocketAddress)channel.remoteAddress()).getAddress()));
        if (configuration != null && configuration.serverSubject() != null) {
            try {
                return Subject.doAs(configuration.serverSubject(), () -> sap.createSaslServer(mech, principals, protocol, configuration.serverName(), configuration.mechProperties()));
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
        Map<String, String> mechProperties = configuration != null ? configuration.mechProperties() : null;
        String serverName = configuration != null ? configuration.serverName() : null;
        return sap.createSaslServer(mech, principals, protocol, serverName, mechProperties);
    }
}

