/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.ScopeFilter;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@Scope(value=Scopes.GLOBAL)
public final class CacheIgnoreManager {
    private static final ScopedState IGNORED_CACHES_KEY = new ScopedState("ignored-caches", "ignored-caches");
    private Cache<ScopedState, Object> cache;
    private final IgnoredCaches ignored = new IgnoredCaches();
    private final CacheListener listener = new CacheListener();
    private volatile boolean hasIgnores;
    private volatile boolean stopped;
    @Inject
    EmbeddedCacheManager cacheManager;
    @Inject
    GlobalConfigurationManager configurationManager;

    CacheIgnoreManager() {
    }

    @Start
    public void start() {
        this.cache = this.configurationManager.getStateCache();
        this.updateLocalCopy((IgnoredCaches)this.cache.get((Object)IGNORED_CACHES_KEY));
        this.cache.addListener((Object)this.listener, (CacheEventFilter)new ScopeFilter(IGNORED_CACHES_KEY.getScope()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> unignoreCache(String cacheName) {
        CacheIgnoreManager cacheIgnoreManager = this;
        synchronized (cacheIgnoreManager) {
            this.ignored.caches.remove(cacheName);
            this.hasIgnores = !this.ignored.caches.isEmpty();
            return this.cache.putAsync((Object)IGNORED_CACHES_KEY, (Object)this.ignored).thenApply(r -> null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> ignoreCache(String cacheName) {
        CacheIgnoreManager cacheIgnoreManager = this;
        synchronized (cacheIgnoreManager) {
            this.ignored.caches.add(cacheName);
            this.hasIgnores = !this.ignored.caches.isEmpty();
            return this.cache.putAsync((Object)IGNORED_CACHES_KEY, (Object)this.ignored).thenApply(r -> null);
        }
    }

    public Set<String> getIgnoredCaches() {
        return Collections.unmodifiableSet(this.ignored.caches);
    }

    boolean isCacheIgnored(String cacheName) {
        return this.hasIgnores && this.ignored.caches.contains(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalCopy(IgnoredCaches ignored) {
        if (ignored != null) {
            CacheIgnoreManager cacheIgnoreManager = this;
            synchronized (cacheIgnoreManager) {
                this.ignored.caches.clear();
                this.ignored.caches.addAll(ignored.caches);
                this.hasIgnores = !this.ignored.caches.isEmpty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Stop
    public void stop() {
        CacheIgnoreManager cacheIgnoreManager = this;
        synchronized (cacheIgnoreManager) {
            if (!this.stopped && this.cache != null) {
                this.cache.removeListener((Object)this.listener);
            }
            this.stopped = true;
        }
    }

    @ProtoTypeId(value=5400)
    static final class IgnoredCaches {
        @ProtoField(number=1, collectionImplementation=HashSet.class)
        final Set<String> caches;

        IgnoredCaches() {
            this(ConcurrentHashMap.newKeySet());
        }

        @ProtoFactory
        IgnoredCaches(Set<String> caches) {
            this.caches = ConcurrentHashMap.newKeySet(caches.size());
            this.caches.addAll(caches);
        }
    }

    @Listener(observation=Listener.Observation.POST)
    private final class CacheListener {
        private CacheListener() {
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<String, IgnoredCaches> e) {
            if (!e.isOriginLocal()) {
                CacheIgnoreManager.this.updateLocalCopy((IgnoredCaches)e.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<String, IgnoredCaches> e) {
            if (!e.isOriginLocal()) {
                CacheIgnoreManager.this.updateLocalCopy((IgnoredCaches)e.getValue());
            }
        }
    }
}

