/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
public interface BackupManager {
    public void init() throws IOException;

    public Set<String> getBackupNames();

    public Status getBackupStatus(String var1);

    public Path getBackupLocation(String var1);

    public CompletionStage<Status> removeBackup(String var1);

    public CompletionStage<Path> create(String var1, Path var2);

    public CompletionStage<Path> create(String var1, Path var2, Map<String, Resources> var3);

    public CompletionStage<Void> restore(Path var1);

    public CompletionStage<Void> restore(Path var1, Map<String, Resources> var2);

    public static interface Resources {
        public Set<Type> includeTypes();

        public Set<String> getQualifiedResources(Type var1);

        public static enum Type {
            CACHES("caches"),
            CACHE_CONFIGURATIONS("cache-configs"),
            COUNTERS("counters"),
            PROTO_SCHEMAS("proto-schemas"),
            SCRIPTS("scripts");

            final String name;

            private Type(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }

            public static Type fromString(String s) {
                for (Type t : Type.values()) {
                    if (!t.name.equalsIgnoreCase(s)) continue;
                    return t;
                }
                throw new IllegalArgumentException(String.format("Type with name '%s' does not exist", s));
            }
        }
    }

    public static enum Status {
        COMPLETE,
        FAILED,
        IN_PROGRESS,
        NOT_FOUND;

    }
}

