/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.DistributedScript;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.scripting.impl.SystemBindings;
import org.infinispan.scripting.logging.Log;
import org.infinispan.util.function.TriConsumer;

public class DistributedRunner
implements ScriptRunner {
    private static final Log log = Log.getLog(DistributedRunner.class);
    public static final DistributedRunner INSTANCE = new DistributedRunner();

    private DistributedRunner() {
    }

    public <T> CompletableFuture<T> runScript(ScriptingManagerImpl scriptManager, ScriptMetadata metadata, CacheScriptBindings binding) {
        Cache masterCacheNode = (Cache)binding.get(SystemBindings.CACHE.toString());
        if (masterCacheNode == null) {
            throw log.distributedTaskNeedCacheInBinding(metadata.name());
        }
        Map<String, Object> ctxParams = this.extractContextParams(metadata, binding);
        ClusterExecutor clusterExecutor = masterCacheNode.getCacheManager().executor();
        ArrayList results = new ArrayList();
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            DistributedRunner distributedRunner = this;
            synchronized (distributedRunner) {
                results.add(v);
            }
        };
        CompletableFuture future = clusterExecutor.submitConsumer(new DistributedScript(masterCacheNode.getName(), metadata, ctxParams), triConsumer);
        return future.thenApply(ignore -> results);
    }

    private Map<String, Object> extractContextParams(ScriptMetadata metadata, CacheScriptBindings binding) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        metadata.parameters().forEach(paramName -> params.put((String)paramName, binding.get(paramName)));
        return params;
    }
}

