/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.script.SimpleBindings;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.security.actions.SecurityActions;

@ProtoTypeId(value=4805)
class DistributedScript<T>
implements Function<EmbeddedCacheManager, T> {
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final ScriptMetadata metadata;
    private final Map<String, ?> ctxParams;

    DistributedScript(String cacheName, ScriptMetadata metadata, Map<String, ?> ctxParams) {
        this.cacheName = cacheName;
        this.metadata = metadata;
        this.ctxParams = ctxParams;
    }

    @ProtoFactory
    DistributedScript(String cacheName, ScriptMetadata metadata, MarshallableMap<String, ?> ctxParams) {
        this(cacheName, metadata, MarshallableMap.unwrap(ctxParams));
    }

    @ProtoField(value=3)
    MarshallableMap<String, ?> getCtxParams() {
        return MarshallableMap.create(this.ctxParams);
    }

    @Override
    public T apply(EmbeddedCacheManager embeddedCacheManager) {
        ScriptingManagerImpl scriptManager = (ScriptingManagerImpl)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)embeddedCacheManager).getComponent(ScriptingManager.class);
        SimpleBindings bindings = new SimpleBindings();
        MediaType scriptMediaType = this.metadata.dataType();
        DataTypedCacheManager dataTypedCacheManager = new DataTypedCacheManager(scriptMediaType, embeddedCacheManager, null);
        bindings.put("cacheManager", (Object)dataTypedCacheManager);
        AdvancedCache cache = embeddedCacheManager.getCache(this.cacheName).getAdvancedCache();
        bindings.put("cache", (Object)cache.withMediaType(scriptMediaType, scriptMediaType));
        this.ctxParams.forEach(bindings::put);
        try {
            return (T)CompletionStages.join(scriptManager.execute(this.metadata, bindings));
        }
        catch (CompletionException e) {
            throw new CacheException(e.getCause());
        }
    }
}

