/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.script.SimpleBindings;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.scripting.impl.DataTypedCacheManager;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.security.actions.SecurityActions;

@SerializeWith(value=Externalizer.class)
class DistributedScript<T>
implements Function<EmbeddedCacheManager, T> {
    private final String cacheName;
    private final ScriptMetadata metadata;
    private final Map<String, ?> ctxParams;

    DistributedScript(String cacheName, ScriptMetadata metadata, Map<String, ?> ctxParams) {
        this.cacheName = cacheName;
        this.metadata = metadata;
        this.ctxParams = ctxParams;
    }

    @Override
    public T apply(EmbeddedCacheManager embeddedCacheManager) {
        ScriptingManagerImpl scriptManager = (ScriptingManagerImpl)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)embeddedCacheManager).getComponent(ScriptingManager.class);
        SimpleBindings bindings = new SimpleBindings();
        MediaType scriptMediaType = this.metadata.dataType();
        DataTypedCacheManager dataTypedCacheManager = new DataTypedCacheManager(scriptMediaType, embeddedCacheManager, null);
        bindings.put("cacheManager", (Object)dataTypedCacheManager);
        AdvancedCache cache = embeddedCacheManager.getCache(this.cacheName).getAdvancedCache();
        bindings.put("cache", (Object)cache.withMediaType(scriptMediaType, scriptMediaType));
        this.ctxParams.forEach(bindings::put);
        try {
            return (T)CompletionStages.join(scriptManager.execute(this.metadata, bindings));
        }
        catch (CompletionException e) {
            throw new CacheException(e.getCause());
        }
    }

    public static class Externalizer
    implements org.infinispan.commons.marshall.Externalizer<DistributedScript> {
        public void writeObject(ObjectOutput output, DistributedScript object) throws IOException {
            output.writeUTF(object.cacheName);
            output.writeObject(object.metadata);
            MarshallUtil.marshallMap(object.ctxParams, (ObjectOutput)output);
        }

        public DistributedScript readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String cacheName = input.readUTF();
            ScriptMetadata metadata = (ScriptMetadata)input.readObject();
            Map ctxParams = MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
            return new DistributedScript(cacheName, metadata, ctxParams);
        }
    }
}

