/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.mapping.reference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.infinispan.api.annotations.indexing.option.Structure;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingKeyMetadata;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.SpatialFieldMapping;
import org.infinispan.query.remote.impl.indexing.infinispan.IndexingMetadataHolder;
import org.infinispan.query.remote.impl.mapping.reference.FieldReferenceProvider;
import org.infinispan.query.remote.impl.mapping.reference.IndexReferenceHolder;
import org.infinispan.query.remote.impl.mapping.reference.SpatialReferenceProvider;

public final class MessageReferenceProvider {
    public static final Set<String> COMMON_MESSAGE_TYPES = new HashSet<String>(Arrays.asList(FieldReferenceProvider.COMMON_MESSAGE_TYPES));
    private final IndexingMetadata indexingMetadata;
    private final List<FieldReferenceProvider> fields;
    private final List<SpatialReferenceProvider> geoFields;
    private final List<Embedded> embedded;
    private final String keyMessageName;
    private final String keyPropertyName;

    public MessageReferenceProvider(Descriptor descriptor) {
        this(descriptor, (IndexingMetadata)IndexingMetadata.findProcessedAnnotation(descriptor, "Indexed"));
    }

    public MessageReferenceProvider(Descriptor descriptor, IndexingMetadata indexingMetadata) {
        this.indexingMetadata = indexingMetadata;
        this.fields = new ArrayList<FieldReferenceProvider>(descriptor.getFields().size());
        this.embedded = new ArrayList<Embedded>();
        if (indexingMetadata == null) {
            this.keyMessageName = null;
            this.keyPropertyName = null;
            this.geoFields = null;
            return;
        }
        this.geoFields = new ArrayList<SpatialReferenceProvider>(indexingMetadata.getSpatialFields().size());
        for (FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            String fieldName = fieldDescriptor.getName();
            FieldMapping fieldMapping = indexingMetadata.getFieldMapping(fieldName);
            if (fieldMapping == null) continue;
            if (Type.MESSAGE.equals((Object)fieldDescriptor.getType()) && !COMMON_MESSAGE_TYPES.contains(fieldDescriptor.getTypeName())) {
                if (!fieldMapping.searchable()) continue;
                this.embedded.add(new Embedded(fieldName, fieldDescriptor.getMessageType().getFullName(), fieldDescriptor.isRepeated(), fieldMapping, (IndexingMetadataHolder)fieldDescriptor.getProcessedAnnotation("Embedded")));
                continue;
            }
            FieldReferenceProvider fieldReferenceProvider = new FieldReferenceProvider(fieldDescriptor, fieldMapping);
            if (fieldReferenceProvider.nothingToBind()) continue;
            this.fields.add(fieldReferenceProvider);
        }
        IndexingKeyMetadata keyMetadata = indexingMetadata.indexingKey();
        if (keyMetadata != null) {
            this.embedded.add(new Embedded(keyMetadata.fieldName(), keyMetadata.typeFullName(), keyMetadata.includeDepth()));
            this.keyMessageName = keyMetadata.typeFullName();
            this.keyPropertyName = keyMetadata.fieldName();
        } else {
            this.keyMessageName = null;
            this.keyPropertyName = null;
        }
        for (SpatialFieldMapping field : indexingMetadata.getSpatialFields().values()) {
            this.geoFields.add(new SpatialReferenceProvider(field));
        }
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public HashMap<String, IndexFieldReference<?>> bind(IndexSchemaElement indexSchemaElement, String basePath) {
        HashMap result = new HashMap();
        for (FieldReferenceProvider field : this.fields) {
            String newPath = "".equals(basePath) ? field.getName() : basePath + "." + field.getName();
            result.put(newPath, field.bind(indexSchemaElement));
        }
        return result;
    }

    public Map<String, IndexReferenceHolder.GeoIndexFieldReference> bindGeo(IndexSchemaElement indexSchemaElement, String basePath) {
        HashMap<String, IndexReferenceHolder.GeoIndexFieldReference> result = new HashMap<String, IndexReferenceHolder.GeoIndexFieldReference>();
        for (SpatialReferenceProvider field : this.geoFields) {
            IndexFieldReference<GeoPoint> fieldReference = field.bind(indexSchemaElement);
            String latitudePath = "".equals(basePath) ? field.latitudeName() : basePath + "." + field.latitudeName();
            String longitudePath = "".equals(basePath) ? field.longitudeName() : basePath + "." + field.longitudeName();
            IndexReferenceHolder.GeoIndexFieldReference latitudeRef = new IndexReferenceHolder.GeoIndexFieldReference(IndexReferenceHolder.GeoIndexFieldReference.Role.LAT, fieldReference, field.indexName());
            IndexReferenceHolder.GeoIndexFieldReference longitudeRef = new IndexReferenceHolder.GeoIndexFieldReference(IndexReferenceHolder.GeoIndexFieldReference.Role.LON, fieldReference, field.indexName());
            result.put(latitudePath, latitudeRef);
            result.put(longitudePath, longitudeRef);
        }
        return result;
    }

    public List<Embedded> getEmbedded() {
        return this.embedded;
    }

    public String keyMessageName() {
        return this.keyMessageName;
    }

    public String keyPropertyName() {
        return this.keyPropertyName;
    }

    public IndexingMetadata indexingMetadata() {
        return this.indexingMetadata;
    }

    public String toString() {
        return "{fields=" + String.valueOf(this.fields) + ", embedded=" + String.valueOf(this.embedded) + "}";
    }

    public static final class Embedded {
        private final String fieldName;
        private final String typeFullName;
        private final boolean repeated;
        private final Integer includeDepth;
        private final ObjectStructure structure;
        private final IndexingMetadataHolder holder;

        private Embedded(String fieldName, String typeFullName, boolean repeated, FieldMapping fieldMapping, IndexingMetadataHolder holder) {
            this.fieldName = fieldName;
            this.typeFullName = typeFullName;
            this.repeated = repeated;
            this.includeDepth = fieldMapping.includeDepth();
            this.structure = fieldMapping.structure() == null ? null : (Structure.NESTED.equals((Object)fieldMapping.structure()) ? ObjectStructure.NESTED : ObjectStructure.FLATTENED);
            this.holder = holder;
        }

        private Embedded(String fieldName, String typeFullName, Integer includeDepth) {
            this.fieldName = fieldName;
            this.typeFullName = typeFullName;
            this.repeated = false;
            this.includeDepth = includeDepth;
            this.structure = ObjectStructure.DEFAULT;
            this.holder = null;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getTypeFullName() {
            return this.typeFullName;
        }

        public boolean isRepeated() {
            return this.repeated;
        }

        public Integer getIncludeDepth() {
            return this.includeDepth;
        }

        public ObjectStructure getStructure() {
            return this.structure;
        }

        public void indexingMetadata(IndexingMetadata indexingMetadata) {
            if (this.holder != null) {
                this.holder.setIndexingMetadata(indexingMetadata);
            }
        }

        public String toString() {
            return "{fieldName='" + this.fieldName + "', typeName='" + this.typeFullName + "'}";
        }
    }
}

