/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.infinispan.commons.CacheException;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.impl.indexing.WrappedMessageTagHandler;
import org.infinispan.query.remote.impl.mapping.reference.GlobalReferenceHolder;
import org.infinispan.query.remote.impl.mapping.type.ProtobufKeyValuePair;
import org.infinispan.search.mapper.mapping.EntityConverter;

public final class ProtobufEntityConverter
implements EntityConverter {
    private static final PojoRawTypeIdentifier<byte[]> BYTE_ARRAY_TYPE_IDENTIFIER = PojoRawTypeIdentifier.of(byte[].class);
    private static final PojoRawTypeIdentifier<ProtobufKeyValuePair> KEY_VALUE_TYPE_IDENTIFIER = PojoRawTypeIdentifier.of(ProtobufKeyValuePair.class);
    private final SerializationContext serializationContext;
    private final GlobalReferenceHolder globalReferenceHolder;
    private final Set<String> indexedMessageTypes;

    public ProtobufEntityConverter(SerializationContext serializationContext, GlobalReferenceHolder globalReferenceHolder) {
        this.serializationContext = serializationContext;
        this.globalReferenceHolder = globalReferenceHolder;
        this.indexedMessageTypes = globalReferenceHolder.getRootMessages().stream().map(rootMessage -> rootMessage.getFullName()).collect(Collectors.toSet());
    }

    public Class<?> targetType() {
        return ProtobufValueWrapper.class;
    }

    public Set<PojoRawTypeIdentifier<?>> convertedTypeIdentifiers() {
        return Set.of(BYTE_ARRAY_TYPE_IDENTIFIER, KEY_VALUE_TYPE_IDENTIFIER);
    }

    public boolean typeIsIndexed(Class<?> type) {
        return type.equals(this.targetType());
    }

    public EntityConverter.ConvertedEntity convert(Object entity, Object providedId) {
        ProtobufValueWrapper valueWrapper = (ProtobufValueWrapper)entity;
        WrappedMessageTagHandler tagHandler = new WrappedMessageTagHandler(valueWrapper, this.serializationContext);
        try {
            Descriptor wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
            ProtobufParser.INSTANCE.parse((TagHandler)tagHandler, wrapperDescriptor, valueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        Descriptor messageDescriptor = valueWrapper.getMessageDescriptor();
        if (messageDescriptor == null) {
            return new ProtobufConvertedEntity(true, null, null);
        }
        String entityName = messageDescriptor.getFullName();
        boolean skip = !this.indexedMessageTypes.contains(entityName);
        byte[] messageBytes = tagHandler.getMessageBytes();
        if (skip || !this.globalReferenceHolder.hasKeyMapping(entityName)) {
            return new ProtobufConvertedEntity(skip, entityName, messageBytes);
        }
        ProtobufValueWrapper keyValueWrapper = new ProtobufValueWrapper((byte[])providedId);
        tagHandler = new WrappedMessageTagHandler(keyValueWrapper, this.serializationContext);
        try {
            Descriptor wrapperDescriptor = this.serializationContext.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
            ProtobufParser.INSTANCE.parse((TagHandler)tagHandler, wrapperDescriptor, keyValueWrapper.getBinary());
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        return new ProtobufKeyValueConvertedEntity(skip, entityName, tagHandler.getMessageBytes(), messageBytes);
    }

    private static final class ProtobufConvertedEntity
    implements EntityConverter.ConvertedEntity {
        private final boolean skip;
        private final String entityName;
        private final byte[] value;

        ProtobufConvertedEntity(boolean skip, String entityName, byte[] value) {
            this.skip = skip;
            this.entityName = entityName;
            this.value = value;
        }

        public boolean skip() {
            return this.skip;
        }

        public String entityName() {
            return this.entityName;
        }

        public Object value() {
            return this.value;
        }
    }

    private static class ProtobufKeyValueConvertedEntity
    implements EntityConverter.ConvertedEntity {
        private final boolean skip;
        private final String entityName;
        private final ProtobufKeyValuePair value;

        public ProtobufKeyValueConvertedEntity(boolean skip, String entityName, byte[] key, byte[] value) {
            this.skip = skip;
            this.entityName = entityName;
            this.value = new ProtobufKeyValuePair(key, value);
        }

        public boolean skip() {
            return this.skip;
        }

        public String entityName() {
            return this.entityName;
        }

        public Object value() {
            return this.value;
        }
    }
}

