/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.WrappedMessage;

public final class ContinuousQueryResult {
    private final boolean isJoining;
    private final byte[] key;
    private final byte[] value;
    private final Object[] projection;

    public ContinuousQueryResult(boolean isJoining, byte[] key, byte[] value, Object[] projection) {
        this.isJoining = isJoining;
        this.key = key;
        this.value = value;
        this.projection = projection;
    }

    public boolean isJoining() {
        return this.isJoining;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public String toString() {
        return "ContinuousQueryResult{isJoining=" + this.isJoining + ", key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + ", projection=" + Arrays.toString(this.projection) + '}';
    }

    public static final class Marshaller
    implements MessageMarshaller<ContinuousQueryResult> {
        public ContinuousQueryResult readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
            boolean isJoining = reader.readBoolean("isJoining");
            byte[] key = reader.readBytes("key");
            byte[] value = reader.readBytes("value");
            List projection = (List)reader.readCollection("projection", new ArrayList(), WrappedMessage.class);
            Object[] p = null;
            if (!projection.isEmpty()) {
                p = new Object[projection.size()];
                int j = 0;
                for (WrappedMessage m : projection) {
                    p[j++] = m.getValue();
                }
            }
            return new ContinuousQueryResult(isJoining, key, value, p);
        }

        public void writeTo(MessageMarshaller.ProtoStreamWriter writer, ContinuousQueryResult continuousQueryResult) throws IOException {
            writer.writeBoolean("isJoining", continuousQueryResult.isJoining);
            writer.writeBytes("key", continuousQueryResult.key);
            if (continuousQueryResult.projection == null) {
                writer.writeBytes("value", continuousQueryResult.value);
            } else {
                Object[] p = new WrappedMessage[continuousQueryResult.projection.length];
                for (int i = 0; i < p.length; ++i) {
                    p[i] = new WrappedMessage(continuousQueryResult.projection[i]);
                }
                writer.writeArray("projection", p, WrappedMessage.class);
            }
        }

        public Class<? extends ContinuousQueryResult> getJavaClass() {
            return ContinuousQueryResult.class;
        }

        public String getTypeName() {
            return "org.infinispan.query.remote.client.ContinuousQueryResult";
        }
    }
}

