/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.InputStream;
import java.net.URL;
import java.util.ServiceLoader;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;

final class ClassLoaderServiceImpl
implements ClassLoaderService {
    private final ClassLoader classLoader;

    ClassLoaderServiceImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> Class<T> classForName(String className) {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (Exception e) {
            throw new ClassLoadingException("Unable to load class [" + className + "]", (Throwable)e);
        }
    }

    public URL locateResource(String name) {
        try {
            return this.classLoader.getResource(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream locateResourceStream(String name) {
        try {
            InputStream is = this.classLoader.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        if (name.startsWith("/")) {
            String stripped = name.substring(1);
            try {
                return new URL(stripped).openStream();
            }
            catch (Exception exception) {
                try {
                    return this.classLoader.getResourceAsStream(stripped);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public <S> Iterable<S> loadJavaServices(Class<S> serviceContract) {
        return ServiceLoader.load(serviceContract, this.classLoader);
    }
}

