/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.CachingWrapperFilter;
import org.hibernate.search.filter.ChainedFilter;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.query.FullTextFilterImpl;
import org.hibernate.search.query.IndexSearcherWithPayload;
import org.hibernate.search.query.QueryHits;
import org.hibernate.search.query.TimeoutManager;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.FilterCacheModeTypeHelper;
import org.hibernate.transform.ResultTransformer;
import org.infinispan.Cache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.backend.IndexSearcherCloser;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheQueryImpl
implements CacheQuery {
    private static final Log log = LogFactory.getLog(CacheQueryImpl.class);
    private Sort sort;
    private Filter filter;
    private Map<String, FullTextFilterImpl> filterDefinitions;
    private Integer firstResult;
    private Integer resultSize;
    private Integer maxResults;
    private boolean needClassFilterClause;
    private String[] indexProjection;
    private ResultTransformer resultTransformer;
    private Set<Class<?>> classesAndSubclasses;
    private Set<String> idFieldNames;
    private boolean allowFieldSelectionInProjection = true;
    private Query luceneQuery;
    private SearchFactoryImplementor searchFactory;
    private Set<Class<?>> targetedEntities;
    private Cache cache;

    public CacheQueryImpl(Query luceneQuery, SearchFactoryImplementor searchFactory, Cache cache, Class ... classes) {
        this.luceneQuery = luceneQuery;
        this.cache = cache;
        this.searchFactory = searchFactory;
        this.targetedEntities = classes == null || classes.length == 0 ? this.searchFactory.getIndexedTypesPolymorphic(new Class[0]) : this.searchFactory.getIndexedTypesPolymorphic(classes);
    }

    @Override
    public void setFilter(Filter f) {
        this.filter = f;
    }

    @Override
    public int getResultSize() {
        if (this.resultSize == null) {
            IndexSearcher searcher = this.buildSearcher(this.searchFactory);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    TopDocs hits = this.getQueryHits((IndexSearcher)searcher, (Integer)Integer.valueOf((int)1)).topDocs;
                    this.resultSize = hits.totalHits;
                }
                catch (IOException e) {
                    throw new SearchException("Unable to query Lucene index", (Throwable)e);
                }
                finally {
                    try {
                        this.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
                    }
                    catch (SearchException e) {
                        log.warn((Object)("Unable to properly close searcher during lucene query: " + (Object)((Object)e)));
                    }
                }
            }
        }
        return this.resultSize;
    }

    private void closeSearcher(Searcher searcher, ReaderProvider readerProvider) {
        Set indexReaders = ReaderProviderHelper.getIndexReaders((Searchable)searcher);
        for (IndexReader indexReader : indexReaders) {
            readerProvider.closeReader(indexReader);
        }
    }

    @Override
    public void setSort(Sort s) {
        this.sort = s;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        FullTextFilterImpl filterDefinition;
        if (this.filterDefinitions == null) {
            this.filterDefinitions = new HashMap<String, FullTextFilterImpl>();
        }
        if ((filterDefinition = this.filterDefinitions.get(name)) != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.searchFactory.getFilterDefinition(name);
        if (filterDef == null) {
            throw new SearchException("Unkown @FullTextFilter: " + name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.filterDefinitions.remove(name);
    }

    @Override
    public void setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
    }

    @Override
    public QueryIterator iterator() throws SearchException {
        return this.iterator(1);
    }

    @Override
    public QueryIterator iterator(int fetchSize) throws SearchException {
        ArrayList<Object> keyList = null;
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        if (searcher == null) {
            throw new NullPointerException("IndexSearcher instance is null.");
        }
        try {
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            keyList = new ArrayList<Object>(size);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactory, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            for (int index = first; index <= max; ++index) {
                String keyString = (String)((Object)extractor.extract((int)index).id);
                keyList.add(KeyTransformationHandler.stringToKey(keyString));
            }
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            IndexSearcherCloser.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
        }
        return new EagerIterator(keyList, this.cache, fetchSize);
    }

    @Override
    public QueryIterator lazyIterator() {
        return this.lazyIterator(1);
    }

    @Override
    public QueryIterator lazyIterator(int fetchSize) {
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        try {
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactory, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            return new LazyIterator(extractor, this.cache, searcher, this.searchFactory, first, max, fetchSize);
        }
        catch (IOException e) {
            try {
                IndexSearcherCloser.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
            }
            catch (SearchException ee) {
                // empty catch block
            }
            throw new SearchException("Unable to query Lucene index", (Throwable)e);
        }
    }

    @Override
    public List<Object> list() throws SearchException {
        IndexSearcher searcher = this.buildSearcher(this.searchFactory);
        if (searcher == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<Object> arrayList;
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactory, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            ArrayList<String> keysForCache = new ArrayList<String>(size);
            for (int index = first; index <= max; ++index) {
                String cacheKey = extractor.extract((int)index).id.toString();
                keysForCache.add(cacheKey);
            }
            ArrayList<Object> listToReturn = new ArrayList<Object>(size);
            for (String key : keysForCache) {
                listToReturn.add(this.cache.get(KeyTransformationHandler.stringToKey(key)));
            }
            if (this.resultTransformer == null) {
                arrayList = listToReturn;
                return arrayList;
            }
            arrayList = this.resultTransformer.transformList(listToReturn);
            return arrayList;
        }
        catch (IOException e) {
            throw new SearchException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            IndexSearcherCloser.closeSearcher((Searcher)searcher, this.searchFactory.getReaderProvider());
        }
    }

    private int max(int first, int totalHits) {
        if (this.maxResults == null) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }

    private int first() {
        return this.firstResult != null ? this.firstResult : 0;
    }

    private QueryHits getQueryHits(IndexSearcher searcher, Integer n) throws IOException {
        Query query = this.filterQueryByClasses(this.luceneQuery);
        this.buildFilters();
        IndexSearcherWithPayload realSearcher = new IndexSearcherWithPayload(searcher, false, false);
        TimeoutManager timeoutManager = new TimeoutManager();
        QueryHits queryHits = n == null ? new QueryHits(realSearcher, query, this.filter, this.sort, timeoutManager) : new QueryHits(realSearcher, query, this.filter, this.sort, n, timeoutManager);
        this.resultSize = queryHits.totalHits;
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (this.maxResults == null) {
            return null;
        }
        return this.first() + this.maxResults;
    }

    @Override
    public void setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
    }

    private IndexSearcher buildSearcher(SearchFactoryImplementor searchFactoryImplementor) {
        Map builders = searchFactoryImplementor.getDocumentBuildersIndexedEntities();
        ArrayList<DirectoryProvider> directories = new ArrayList<DirectoryProvider>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        if (this.targetedEntities.isEmpty()) {
            if (builders.isEmpty()) {
                throw new SearchException("There are no mapped entities. Don't forget to add @Indexed to at least one class.");
            }
            for (DocumentBuilderIndexedEntity builder : builders.values()) {
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                DirectoryProvider[] directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards();
                this.populateDirectories(directories, directoryProviders);
            }
            this.classesAndSubclasses = null;
        } else {
            DocumentBuilderIndexedEntity builder;
            HashSet involvedClasses = new HashSet(this.targetedEntities.size());
            involvedClasses.addAll(this.targetedEntities);
            for (Class<Object> clazz : this.targetedEntities) {
                builder = (DocumentBuilderIndexedEntity)builders.get(clazz);
                if (builder == null) continue;
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class<Object> clazz : involvedClasses) {
                builder = (DocumentBuilderIndexedEntity)builders.get(clazz);
                if (builder == null) {
                    throw new SearchException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                DirectoryProvider[] directoryProviders = builder.getDirectoryProviderSelectionStrategy().getDirectoryProvidersForAllShards();
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                this.populateDirectories(directories, directoryProviders);
            }
            this.classesAndSubclasses = involvedClasses;
        }
        this.idFieldNames = idFieldNames;
        if (this.classesAndSubclasses != null) {
            for (DirectoryProvider dp : directories) {
                Set classesInDirectoryProvider = searchFactoryImplementor.getClassesInDirectoryProvider(dp);
                if (classesInDirectoryProvider.size() > 1) {
                    for (Class clazz : classesInDirectoryProvider) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        }
        DirectoryProvider[] directoryProviders = directories.toArray(new DirectoryProvider[directories.size()]);
        IndexSearcher is = new IndexSearcher(searchFactoryImplementor.getReaderProvider().openReader(directoryProviders));
        is.setSimilarity(searcherSimilarity);
        return is;
    }

    private Similarity checkSimilarity(Similarity similarity, DocumentBuilderIndexedEntity builder) {
        if (similarity == null) {
            similarity = builder.getSimilarity();
        } else if (!similarity.getClass().equals(builder.getSimilarity().getClass())) {
            throw new SearchException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + builder.getSimilarity().getClass().getName() + ")");
        }
        return similarity;
    }

    private void populateDirectories(List<DirectoryProvider> directories, DirectoryProvider[] directoryProviders) {
        for (DirectoryProvider provider : directoryProviders) {
            if (directories.contains(provider)) continue;
            directories.add(provider);
        }
    }

    private Query filterQueryByClasses(Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class<?> clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add((Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((Query)classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private void buildFilters() {
        if (this.filterDefinitions == null || this.filterDefinitions.isEmpty()) {
            return;
        }
        ChainedFilter chainedFilter = new ChainedFilter();
        for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
            Filter filter = this.buildLuceneFilter(fullTextFilter);
            chainedFilter.addFilter(filter);
        }
        if (this.filter != null) {
            chainedFilter.addFilter(this.filter);
        }
        this.filter = chainedFilter;
    }

    private Filter buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        Filter filter;
        FilterDef def = this.searchFactory.getFilterDefinition(fullTextFilter.getName());
        Object instance = this.createFilterInstance(fullTextFilter, def);
        FilterKey key = this.createFilterKey(def, instance);
        Filter filter2 = filter = FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode()) ? this.searchFactory.getFilterCachingStrategy().getCachedFilter(key) : null;
        if (filter == null) {
            filter = this.createFilter(def, instance);
            if (FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode())) {
                this.searchFactory.getFilterCachingStrategy().addCachedFilter(key, filter);
            }
        }
        return filter;
    }

    private Filter createFilter(FilterDef def, Object instance) {
        Filter filter;
        if (def.getFactoryMethod() != null) {
            try {
                filter = (Filter)def.getFactoryMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName());
            }
        }
        try {
            filter = (Filter)instance;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not implement the Filter interface: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), (Throwable)e);
        }
        filter = this.addCachingWrapperFilter(filter, def);
        return filter;
    }

    private Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance;
        try {
            instance = def.getImpl().newInstance();
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), (Throwable)e);
        }
        for (Map.Entry entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke((String)entry.getKey(), instance, entry.getValue());
        }
        if (FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode()) && def.getKeyMethod() == null && !fullTextFilter.getParameters().isEmpty()) {
            throw new SearchException("Filter with parameters and no @Key method: " + fullTextFilter.getName());
        }
        return instance;
    }

    private FilterKey createFilterKey(FilterDef def, Object instance) {
        FilterKey key = null;
        if (!FilterCacheModeTypeHelper.cacheInstance((FilterCacheModeType)def.getCacheMode())) {
            return key;
        }
        if (def.getKeyMethod() == null) {
            key = new FilterKey(){

                public int hashCode() {
                    return this.getImpl().hashCode();
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof FilterKey)) {
                        return false;
                    }
                    FilterKey that = (FilterKey)obj;
                    return this.getImpl().equals(that.getImpl());
                }
            };
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
        }
        key.setImpl(def.getImpl());
        StandardFilterKey wrapperKey = new StandardFilterKey();
        wrapperKey.addParameter((Object)def.getName());
        wrapperKey.addParameter((Object)key);
        return wrapperKey;
    }

    private Filter addCachingWrapperFilter(Filter filter, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults((FilterCacheModeType)def.getCacheMode())) {
            int cachingWrapperFilterSize = this.searchFactory.getFilterCacheBitResultsSize();
            filter = new CachingWrapperFilter(filter, cachingWrapperFilterSize);
        }
        return filter;
    }
}

