/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.Cache;
import org.infinispan.query.impl.AbstractIterator;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@NotThreadSafe
public class EagerIterator
extends AbstractIterator {
    private List<Object> idList;
    private static final Log log = LogFactory.getLog(EagerIterator.class);

    public EagerIterator(List<Object> idList, Cache cache, int fetchSize) {
        if (fetchSize < 1) {
            throw new IllegalArgumentException("Incorrect value for fetchsize passed. Your fetchSize is less than 1");
        }
        this.idList = idList;
        this.cache = cache;
        this.fetchSize = fetchSize;
        this.first = 0;
        this.max = idList.size() - 1;
        this.buffer = new Object[this.fetchSize];
    }

    @Override
    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        if (index > this.idList.size() || index < 0) {
            throw new IndexOutOfBoundsException("The index you entered is either greater than the size of the list or negative");
        }
        this.index = index;
    }

    @Override
    public void close() {
    }

    @Override
    public Object next() {
        Object toReturn;
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("Out of boundaries. There is no next");
        }
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index >= this.bufferIndex && this.index < this.bufferIndex + bufferSize) {
            int indexToReturn = this.index - this.bufferIndex;
            toReturn = this.buffer[indexToReturn];
        } else {
            toReturn = this.cache.get(this.idList.get(this.index));
            Arrays.fill(this.buffer, null);
            this.buffer[0] = toReturn;
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                if (this.index + i > this.max) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Your current index + bufferSize exceeds the size of your number of hits");
                    break;
                }
                this.buffer[i] = toBuffer = this.cache.get(this.idList.get(this.index + i));
            }
            this.bufferIndex = this.index;
        }
        ++this.index;
        return toReturn;
    }

    public Object previous() {
        Object toReturn;
        if (!this.hasPrevious()) {
            throw new IndexOutOfBoundsException("Index is out of bounds. There is no previous");
        }
        int bufferSize = this.buffer.length;
        if (this.bufferIndex >= 0 && this.index <= this.bufferIndex && this.index >= this.bufferIndex + bufferSize) {
            int indexToReturn = this.bufferIndex - this.index;
            toReturn = this.buffer[indexToReturn];
        } else {
            toReturn = this.cache.get(this.idList.get(this.index));
            Arrays.fill(this.buffer, null);
            this.buffer[0] = toReturn;
            for (int i = 1; i < bufferSize; ++i) {
                Object toBuffer;
                if (this.index - i < this.first) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)"Your current index - bufferSize exceeds the size of your number of hits");
                    break;
                }
                this.buffer[i] = toBuffer = this.cache.get(this.idList.get(this.index - i));
            }
            this.bufferIndex = this.index;
        }
        --this.index;
        return toReturn;
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache.  Please use searchableCache.put()");
    }

    public void add(Object o) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache. Please use searchableCache.put()");
    }
}

