/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.search.backend.TransactionContext;
import org.infinispan.util.logging.Log;

public class TransactionalEventTransactionContext
implements TransactionContext {
    TransactionManager transactionManager;
    Log log;

    public TransactionalEventTransactionContext(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean isTransactionInProgress() {
        if (this.transactionManager == null) {
            return false;
        }
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            this.log.debug((Object)"Caught SystemException in TransactionalEventTransactionContext", (Throwable)e);
        }
        return transaction != null;
    }

    public Object getTransactionIdentifier() {
        if (this.transactionManager == null) {
            return null;
        }
        Transaction transaction = null;
        try {
            transaction = this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            this.log.debug((Object)"Caught SystemException in TransactionalEventTransactionContext", (Throwable)e);
        }
        return transaction;
    }

    public void registerSynchronization(Synchronization synchronization) {
        if (this.transactionManager != null) {
            if (synchronization == null) {
                throw new NullPointerException("Synchronization passed in is null!");
            }
            try {
                Transaction transaction = this.transactionManager.getTransaction();
                transaction.registerSynchronization(synchronization);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

