/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax;

import org.infinispan.query.objectfilter.SortField;
import org.infinispan.query.objectfilter.impl.ql.PropertyPath;
import org.infinispan.query.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.query.objectfilter.impl.syntax.ConstantBooleanExpr;

public final class SyntaxTreePrinter {
    private SyntaxTreePrinter() {
    }

    public static String printTree(BooleanExpr whereClause) {
        return SyntaxTreePrinter.printTree(whereClause, " WHERE ");
    }

    public static String printTree(BooleanExpr clause, String clauseName) {
        StringBuilder sb = new StringBuilder();
        if (clause != null) {
            if (clause == ConstantBooleanExpr.FALSE) {
                throw new IllegalArgumentException("The clause must not be a contradiction");
            }
            if (clause != ConstantBooleanExpr.TRUE) {
                sb.append(clauseName);
                clause.appendQueryString(sb);
            }
        }
        return sb.toString();
    }

    public static String printTree(String fromEntityTypeName, PropertyPath[] projection, BooleanExpr whereClause, BooleanExpr filtering, SortField[] orderBy) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (projection != null && projection.length != 0) {
            sb.append("SELECT ");
            for (i = 0; i < projection.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(projection[i]);
            }
            sb.append(' ');
        }
        sb.append("FROM ").append(fromEntityTypeName);
        sb.append(SyntaxTreePrinter.printTree(whereClause));
        if (filtering != null) {
            sb.append(SyntaxTreePrinter.printTree(filtering, " FILTERING "));
        }
        if (orderBy != null && orderBy.length != 0) {
            sb.append(" ORDER BY ");
            for (i = 0; i < orderBy.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                SortField sf = orderBy[i];
                sb.append(sf.getPath());
                if (sf.isAscending()) continue;
                sb.append(" DESC");
            }
        }
        return sb.toString();
    }
}

