/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.query.objectfilter.impl.util.ArrayIterator;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static PropertyAccessor getAccessor(Class<?> clazz, String propertyName) throws ReflectiveOperationException {
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("Property name cannot be null or empty");
        }
        if (propertyName.indexOf(46) != -1) {
            throw new IllegalArgumentException("The argument cannot be a nested property name");
        }
        String propertyNameSuffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            PropertyAccessor m = ReflectionHelper.getAccessor(c, propertyName, propertyNameSuffix);
            if (m == null) continue;
            return m;
        }
        throw new ReflectiveOperationException("Property not found: " + propertyName);
    }

    private static PropertyAccessor getAccessor(Class<?> clazz, String propertyName, String propertyNameSuffix) {
        try {
            Method m = clazz.getDeclaredMethod("get" + propertyNameSuffix, new Class[0]);
            if (Modifier.isPublic(m.getModifiers()) && m.getReturnType() != Void.class) {
                return ReflectionHelper.getMethodAccessor(m);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Method m = clazz.getDeclaredMethod("is" + propertyNameSuffix, new Class[0]);
                if (Modifier.isPublic(m.getModifiers()) && (Boolean.TYPE == m.getReturnType() || Boolean.class == m.getReturnType())) {
                    return ReflectionHelper.getMethodAccessor(m);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            Field f = clazz.getDeclaredField(propertyName);
            if (f != null && !f.isSynthetic()) {
                return ReflectionHelper.getFieldAccessor(f);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private static PropertyAccessor getFieldAccessor(Field f) {
        Class<?> fieldClass = f.getType();
        if (fieldClass.isArray()) {
            return new ArrayFieldPropertyAccessor(f);
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            return new CollectionFieldPropertyAccessor(f);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            return new MapFieldPropertyAccessor(f);
        }
        return new FieldPropertyAccessor(f);
    }

    private static PropertyAccessor getMethodAccessor(Method m) {
        Class<?> fieldClass = m.getReturnType();
        if (fieldClass.isArray()) {
            return new ArrayMethodPropertyAccessor(m);
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            return new CollectionMethodPropertyAccessor(m);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            return new MapMethodPropertyAccessor(m);
        }
        return new MethodPropertyAccessor(m);
    }

    private static Class determineElementType(Class<?> type, Type genericType) {
        if (type.isArray()) {
            if (genericType instanceof Class) {
                return type.getComponentType();
            }
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type genericComponentType = genericArrayType.getGenericComponentType();
            if (genericComponentType instanceof ParameterizedType) {
                return (Class)((ParameterizedType)genericComponentType).getRawType();
            }
            return (Class)((TypeVariable)genericComponentType).getBounds()[0];
        }
        if (Collection.class.isAssignableFrom(type)) {
            return ReflectionHelper.determineCollectionElementType(genericType);
        }
        if (Map.class.isAssignableFrom(type)) {
            return ReflectionHelper.determineMapValueTypeParam(genericType);
        }
        return null;
    }

    private static Class determineMapValueTypeParam(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Type fieldArgType = type.getActualTypeArguments()[1];
            if (fieldArgType instanceof TypeVariable) {
                TypeVariable genericComponentType = (TypeVariable)fieldArgType;
                return (Class)genericComponentType.getBounds()[0];
            }
            return (Class)fieldArgType;
        }
        if (genericType instanceof Class) {
            Class x;
            Class c = (Class)genericType;
            if (c.getGenericSuperclass() != null && Map.class.isAssignableFrom(c.getSuperclass()) && (x = ReflectionHelper.determineMapValueTypeParam(c.getGenericSuperclass())) != null) {
                return x;
            }
            for (Type t : c.getGenericInterfaces()) {
                Class x2;
                if ((!(t instanceof Class) || !Map.class.isAssignableFrom((Class)t)) && (!(t instanceof ParameterizedType) || !Map.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) || (x2 = ReflectionHelper.determineMapValueTypeParam(t)) == null) continue;
                return x2;
            }
        }
        return null;
    }

    private static Class determineCollectionElementType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Type fieldArgType = type.getActualTypeArguments()[0];
            if (fieldArgType instanceof Class) {
                return (Class)fieldArgType;
            }
            return (Class)((ParameterizedType)fieldArgType).getRawType();
        }
        if (genericType instanceof Class) {
            Class x;
            Class c = (Class)genericType;
            if (c.getGenericSuperclass() != null && Collection.class.isAssignableFrom(c.getSuperclass()) && (x = ReflectionHelper.determineCollectionElementType(c.getGenericSuperclass())) != null) {
                return x;
            }
            for (Type t : c.getGenericInterfaces()) {
                Class x2;
                if ((!(t instanceof Class) || !Map.class.isAssignableFrom((Class)t)) && (!(t instanceof ParameterizedType) || !Collection.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) || (x2 = ReflectionHelper.determineCollectionElementType(t)) == null) continue;
                return x2;
            }
        }
        return null;
    }

    public static interface PropertyAccessor {
        public Class<?> getPropertyType();

        public boolean isMultiple();

        public Object getValue(Object var1);

        public Iterator<Object> getValueIterator(Object var1);

        public PropertyAccessor getAccessor(String var1) throws ReflectiveOperationException;
    }

    private static final class ArrayFieldPropertyAccessor
    extends FieldPropertyAccessor {
        ArrayFieldPropertyAccessor(Field field) {
            super(field);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            Object value = this.getValue(instance);
            return value == null ? null : new ArrayIterator(value);
        }

        @Override
        public Class<?> getPropertyType() {
            return ReflectionHelper.determineElementType(this.field.getType(), this.field.getGenericType());
        }
    }

    private static final class CollectionFieldPropertyAccessor
    extends FieldPropertyAccessor {
        CollectionFieldPropertyAccessor(Field field) {
            super(field);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            Object value = this.getValue(instance);
            return value == null ? null : ((Collection)value).iterator();
        }

        @Override
        public Class<?> getPropertyType() {
            return ReflectionHelper.determineElementType(this.field.getType(), this.field.getGenericType());
        }
    }

    private static final class MapFieldPropertyAccessor
    extends FieldPropertyAccessor {
        MapFieldPropertyAccessor(Field field) {
            super(field);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            Object value = this.getValue(instance);
            return value == null ? null : ((Map)value).values().iterator();
        }

        @Override
        public Class<?> getPropertyType() {
            return ReflectionHelper.determineElementType(this.field.getType(), this.field.getGenericType());
        }
    }

    private static class FieldPropertyAccessor
    extends BasePropertyAccessor {
        protected final Field field;

        FieldPropertyAccessor(Field field) {
            this.field = field;
            field.setAccessible(true);
        }

        @Override
        public Class<?> getPropertyType() {
            return this.field.getType();
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public Object getValue(Object instance) {
            try {
                return this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            throw new UnsupportedOperationException("This property cannot be iterated");
        }
    }

    private static final class ArrayMethodPropertyAccessor
    extends MethodPropertyAccessor {
        ArrayMethodPropertyAccessor(Method method) {
            super(method);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            Object value = this.getValue(instance);
            return value == null ? null : new ArrayIterator(value);
        }

        @Override
        public Class<?> getPropertyType() {
            return ReflectionHelper.determineElementType(this.method.getReturnType(), this.method.getGenericReturnType());
        }
    }

    private static final class CollectionMethodPropertyAccessor
    extends MethodPropertyAccessor {
        CollectionMethodPropertyAccessor(Method method) {
            super(method);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            Object value = this.getValue(instance);
            return value == null ? null : ((Collection)value).iterator();
        }

        @Override
        public Class<?> getPropertyType() {
            return ReflectionHelper.determineElementType(this.method.getReturnType(), this.method.getGenericReturnType());
        }
    }

    private static final class MapMethodPropertyAccessor
    extends MethodPropertyAccessor {
        MapMethodPropertyAccessor(Method method) {
            super(method);
        }

        @Override
        public boolean isMultiple() {
            return true;
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            Object value = this.getValue(instance);
            return value == null ? null : ((Map)value).values().iterator();
        }

        @Override
        public Class<?> getPropertyType() {
            return ReflectionHelper.determineElementType(this.method.getReturnType(), this.method.getGenericReturnType());
        }
    }

    private static class MethodPropertyAccessor
    extends BasePropertyAccessor {
        protected final Method method;

        MethodPropertyAccessor(Method method) {
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public Class<?> getPropertyType() {
            return this.method.getReturnType();
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public Object getValue(Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Iterator<Object> getValueIterator(Object instance) {
            throw new UnsupportedOperationException("This property cannot be iterated");
        }
    }

    private static abstract class BasePropertyAccessor
    implements PropertyAccessor {
        private BasePropertyAccessor() {
        }

        @Override
        public PropertyAccessor getAccessor(String propName) throws ReflectiveOperationException {
            return ReflectionHelper.getAccessor(this.getPropertyType(), propName);
        }
    }
}

