/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.stats.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.execution.spi.SimpleScheduledExecutor;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.query.Indexer;
import org.infinispan.query.concurrent.InfinispanIndexingExecutorProvider;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.IndexStatisticsSnapshot;
import org.infinispan.query.core.stats.impl.IndexStatisticsSnapshotImpl;
import org.infinispan.query.mapper.mapping.SearchIndexedEntity;
import org.infinispan.query.mapper.mapping.SearchMapping;
import org.infinispan.query.mapper.scope.SearchScope;
import org.infinispan.query.mapper.session.SearchSession;
import org.infinispan.util.concurrent.BlockingManager;

@Scope(value=Scopes.NAMED_CACHE)
public class LocalIndexStatistics
implements IndexStatistics {
    private static final Log log = Log.getLog(LocalIndexStatistics.class);
    @Inject
    SearchMapping searchMapping;
    @Inject
    BlockingManager blockingManager;
    @Inject
    Indexer indexer;
    private SimpleScheduledExecutor offloadingExecutor;

    @Start
    void start() {
        this.offloadingExecutor = InfinispanIndexingExecutorProvider.writeExecutor(this.blockingManager);
    }

    @Override
    public Set<String> indexedEntities() {
        return this.searchMapping.allIndexedEntityNames();
    }

    @Override
    public CompletionStage<Map<String, IndexInfo>> computeIndexInfos() {
        HashMap<String, CompletionStage<IndexInfo>> infoStages = new HashMap<String, CompletionStage<IndexInfo>>();
        AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage(new HashMap());
        for (SearchIndexedEntity searchIndexedEntity : this.searchMapping.indexedEntitiesForStatistics()) {
            CompletionStage<IndexInfo> stage = this.indexInfos(searchIndexedEntity);
            infoStages.put(searchIndexedEntity.name(), stage);
            aggregateCompletionStage.dependsOn(stage);
        }
        return aggregateCompletionStage.freeze().thenApply(map -> {
            infoStages.forEach((name, stage) -> map.put(name, (IndexInfo)CompletionStages.join((CompletionStage)stage)));
            return map;
        });
    }

    private CompletionStage<IndexInfo> indexInfos(SearchIndexedEntity indexedEntity) {
        CompletionStage countStage = this.blockingManager.supplyBlocking(() -> {
            SearchSession session = this.searchMapping.getMappingSession();
            SearchScope<?> scope = session.scope(indexedEntity.javaClass(), indexedEntity.name());
            long hitCount = -1L;
            try {
                hitCount = session.search(scope).where(SearchPredicateFactory::matchAll).fetchTotalHitCount();
            }
            catch (Throwable throwable) {
                log.concurrentReindexingOnGetStatistics(throwable);
            }
            return hitCount;
        }, (Object)this);
        return countStage.thenCompose(count -> {
            CompletionStage<Long> sizeStage;
            if (count == -1L || this.reindexing()) {
                sizeStage = CompletableFuture.completedFuture(-1L);
            } else {
                try {
                    sizeStage = ((LuceneIndexManager)indexedEntity.indexManager().unwrap(LuceneIndexManager.class)).computeSizeInBytesAsync(OperationSubmitter.offloading(task -> this.offloadingExecutor.submit(task))).exceptionally(throwable -> {
                        log.concurrentReindexingOnGetStatistics((Throwable)throwable);
                        return -1L;
                    });
                }
                catch (SearchException exception) {
                    if (exception.getMessage().contains("HSEARCH000563")) {
                        sizeStage = CompletableFuture.completedFuture(-1L);
                    }
                    throw exception;
                }
            }
            return sizeStage.thenApply(size -> new IndexInfo((long)count, (long)size));
        });
    }

    @Override
    public boolean reindexing() {
        return this.indexer.isRunning();
    }

    @Override
    public int genericIndexingFailures() {
        return this.searchMapping.genericIndexingFailures();
    }

    @Override
    public int entityIndexingFailures() {
        return this.searchMapping.entityIndexingFailures();
    }

    @Override
    public CompletionStage<IndexStatisticsSnapshot> computeSnapshot() {
        return this.computeIndexInfos().thenApply(infos -> new IndexStatisticsSnapshotImpl((Map<String, IndexInfo>)infos, this.reindexing(), this.genericIndexingFailures(), this.entityIndexingFailures()));
    }
}

