/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class ArrayIterator<T>
implements Iterator<T> {
    private final Object array;
    private int pos = 0;

    ArrayIterator(Object array) {
        if (array == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Argument is expected to be an array");
        }
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.pos < Array.getLength(this.array);
    }

    @Override
    public T next() {
        try {
            return (T)Array.get(this.array, this.pos++);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }
}

