/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatisticsSnapshot;
import org.infinispan.query.core.stats.impl.IndexEntry;

@ProtoTypeId(value=4203)
public class IndexStatisticsSnapshotImpl
implements IndexStatisticsSnapshot {
    private final Map<String, IndexInfo> indexInfos;
    private final boolean reindexing;
    private int genericIndexingFailures;
    private int entityIndexingFailures;

    public IndexStatisticsSnapshotImpl() {
        this(new HashMap<String, IndexInfo>(), false, 0, 0);
    }

    @ProtoFactory
    public IndexStatisticsSnapshotImpl(List<IndexEntry> entries, boolean reindexing, int genericIndexingFailures, int entityIndexingFailures) {
        this(IndexStatisticsSnapshotImpl.toMap(entries), reindexing, genericIndexingFailures, entityIndexingFailures);
    }

    public IndexStatisticsSnapshotImpl(Map<String, IndexInfo> indexInfos, boolean reindexing, int genericIndexingFailures, int entityIndexingFailures) {
        this.indexInfos = indexInfos;
        this.reindexing = reindexing;
        this.genericIndexingFailures = genericIndexingFailures;
        this.entityIndexingFailures = entityIndexingFailures;
    }

    @Override
    public Map<String, IndexInfo> indexInfos() {
        return this.indexInfos;
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    public List<IndexEntry> getEntries() {
        return IndexStatisticsSnapshotImpl.fromMap(this.indexInfos);
    }

    static Map<String, IndexInfo> toMap(List<IndexEntry> entries) {
        return Collections.unmodifiableMap(entries.stream().collect(Collectors.toMap(IndexEntry::getName, IndexEntry::getIndexInfo)));
    }

    static List<IndexEntry> fromMap(Map<String, IndexInfo> map) {
        return map.entrySet().stream().map(e -> new IndexEntry((String)e.getKey(), (IndexInfo)e.getValue())).collect(Collectors.toList());
    }

    @Override
    @ProtoField(number=2, defaultValue="false")
    public boolean reindexing() {
        return this.reindexing;
    }

    @Override
    @ProtoField(number=3, defaultValue="0")
    public int genericIndexingFailures() {
        return this.genericIndexingFailures;
    }

    @Override
    @ProtoField(number=4, defaultValue="0")
    public int entityIndexingFailures() {
        return this.entityIndexingFailures;
    }

    public Json toJson() {
        return Json.object().set("types", Json.make(this.indexInfos)).set("reindexing", Json.make((Object)this.reindexing)).set("genericIndexingFailures", Json.make((Object)this.genericIndexingFailures)).set("entityIndexingFailures", Json.make((Object)this.entityIndexingFailures));
    }

    @Override
    public IndexStatisticsSnapshot merge(IndexStatisticsSnapshot other) {
        other.indexInfos().forEach((k, v) -> this.indexInfos.merge((String)k, (IndexInfo)v, IndexInfo::merge));
        this.genericIndexingFailures += other.genericIndexingFailures();
        this.entityIndexingFailures += other.entityIndexingFailures();
        return this;
    }
}

