/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax.parser;

import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.query.objectfilter.impl.logging.Log;
import org.infinispan.query.objectfilter.impl.syntax.IndexedFieldProvider;
import org.infinispan.query.objectfilter.impl.syntax.parser.EntityNameResolver;
import org.infinispan.query.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.objectfilter.impl.util.StringHelper;
import org.jboss.logging.Logger;

public class ProtobufPropertyHelper
extends ObjectPropertyHelper<Descriptor> {
    private static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)ProtobufPropertyHelper.class.getName());
    public static final String BIG_INTEGER_COMMON_TYPE = "org.infinispan.protostream.commons.BigInteger";
    public static final String BIG_DECIMAL_COMMON_TYPE = "org.infinispan.protostream.commons.BigDecimal";
    public static final String VERSION = "__ISPN_Version";
    public static final int VERSION_FIELD_ATTRIBUTE_ID = 150000;
    public static final List<Integer> VERSION_FIELD_ATTRIBUTE = List.of(Integer.valueOf(150000));
    public static final int MIN_METADATA_FIELD_ATTRIBUTE_ID = 150000;
    public static final String VALUE = "__HSearch_This";
    public static final int VALUE_FIELD_ATTRIBUTE_ID = 150001;
    public static final List<Integer> VALUE_FIELD_ATTRIBUTE = List.of(Integer.valueOf(150001));
    public static final String SCORE = "__ISPN_Score";
    public static final int SCORE_FIELD_ATTRIBUTE_ID = 150002;
    public static final List<Integer> SCORE_FIELD_ATTRIBUTE = List.of(Integer.valueOf(150002));
    public static final int KEY_FIELD_ATTRIBUTE_ID = 150003;
    private static final IndexedFieldProvider.FieldIndexingMetadata<Descriptor> PROTO_NO_INDEXING = IndexedFieldProvider.noIndexing();
    private static final String EMBEDDED_ANNOTATION = "Embedded";
    private static final String STRUCTURE_ATTRIBUTE_NAME = "structure";
    private static final String NESTED_STRUCTURE_VALUE = "NESTED";
    private final EntityNameResolver<Descriptor> entityNameResolver;
    private final IndexedFieldProvider<Descriptor> indexedFieldProvider;

    public ProtobufPropertyHelper(SerializationContext serializationContext, IndexedFieldProvider<Descriptor> indexedFieldProvider) {
        this(arg_0 -> ((SerializationContext)serializationContext).getMessageDescriptor(arg_0), indexedFieldProvider);
    }

    public ProtobufPropertyHelper(EntityNameResolver<Descriptor> entityNameResolver, IndexedFieldProvider<Descriptor> indexedFieldProvider) {
        this.entityNameResolver = entityNameResolver;
        this.indexedFieldProvider = indexedFieldProvider != null ? indexedFieldProvider : typeMetadata -> PROTO_NO_INDEXING;
    }

    @Override
    public IndexedFieldProvider<Descriptor> getIndexedFieldProvider() {
        return this.indexedFieldProvider;
    }

    @Override
    public Descriptor getEntityMetadata(String typeName) {
        return this.entityNameResolver.resolve(typeName);
    }

    @Override
    public List<?> mapPropertyNamePathToFieldIdPath(Descriptor messageDescriptor, String[] propertyPath) {
        if (propertyPath.length == 1) {
            switch (propertyPath[0]) {
                case "__ISPN_Version": {
                    return VERSION_FIELD_ATTRIBUTE;
                }
                case "__HSearch_This": {
                    return VALUE_FIELD_ATTRIBUTE;
                }
                case "__ISPN_Score": {
                    return SCORE_FIELD_ATTRIBUTE;
                }
            }
        }
        return this.translatePropertyPath(messageDescriptor, propertyPath);
    }

    @Override
    public Class<?> getPrimitivePropertyType(Descriptor entityType, String[] propertyPath) {
        FieldDescriptor field;
        if (propertyPath.length == 1) {
            switch (propertyPath[0]) {
                case "__ISPN_Version": {
                    return Long.class;
                }
                case "__HSearch_This": {
                    return Object.class;
                }
                case "__ISPN_Score": {
                    return Float.class;
                }
            }
        }
        if ((field = this.getField(entityType, propertyPath)) == null) {
            throw log.getNoSuchPropertyException(entityType.getFullName(), StringHelper.join(propertyPath));
        }
        return switch (field.getJavaType()) {
            case JavaType.INT, JavaType.ENUM -> Integer.class;
            case JavaType.LONG -> Long.class;
            case JavaType.FLOAT -> Float.class;
            case JavaType.DOUBLE -> Double.class;
            case JavaType.BOOLEAN -> Boolean.class;
            case JavaType.STRING -> String.class;
            case JavaType.BYTE_STRING -> byte[].class;
            case JavaType.MESSAGE -> {
                switch (field.getTypeName()) {
                    case "org.infinispan.protostream.commons.BigInteger": {
                        yield BigInteger.class;
                    }
                    case "org.infinispan.protostream.commons.BigDecimal": {
                        yield BigDecimal.class;
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public Class<?> getIndexedPropertyType(Descriptor entityType, String[] propertyPath) {
        return this.getPrimitivePropertyType(entityType, propertyPath);
    }

    @Override
    public boolean isNestedIndexStructure(Descriptor entityType, String[] propertyPath) {
        FieldDescriptor field = this.getField(entityType, propertyPath);
        if (field == null) {
            return false;
        }
        Map annotations = field.getAnnotations();
        if (annotations == null) {
            return false;
        }
        AnnotationElement.Annotation annotation = (AnnotationElement.Annotation)annotations.get(EMBEDDED_ANNOTATION);
        if (annotation == null) {
            return false;
        }
        AnnotationElement.Value structure = annotation.getAttributeValue(STRUCTURE_ATTRIBUTE_NAME);
        if (structure == null) {
            return false;
        }
        return NESTED_STRUCTURE_VALUE.equals(structure.getValue());
    }

    private FieldDescriptor getField(Descriptor entityType, String[] propertyPath) {
        Descriptor messageDescriptor = entityType;
        FieldDescriptor field = null;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            field = messageDescriptor.findFieldByName(property);
            if (field != null) {
                if (field.getJavaType() != JavaType.MESSAGE) continue;
                messageDescriptor = field.getMessageType();
                continue;
            }
            if (i == 0 && (messageDescriptor = this.indexedFieldProvider.get(messageDescriptor).keyType(property)) != null) {
                field = ProtobufPropertyHelper.syntheticKeyField(property, messageDescriptor.getFullName());
                continue;
            }
            return null;
        }
        return field;
    }

    private List<Integer> translatePropertyPath(Descriptor entityType, String[] propertyPath) {
        ArrayList<Integer> translatedPath = new ArrayList<Integer>(propertyPath.length);
        Descriptor messageDescriptor = entityType;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            FieldDescriptor field = messageDescriptor.findFieldByName(property);
            if (field != null) {
                translatedPath.add(field.getNumber());
                if (field.getJavaType() != JavaType.MESSAGE) continue;
                messageDescriptor = field.getMessageType();
                continue;
            }
            if (i == 0 && (messageDescriptor = this.indexedFieldProvider.get(messageDescriptor).keyType(property)) != null) {
                field = ProtobufPropertyHelper.syntheticKeyField(property, messageDescriptor.getFullName());
                translatedPath.add(field.getNumber());
                continue;
            }
            return null;
        }
        return translatedPath;
    }

    @Override
    public boolean isRepeatedProperty(Descriptor entityType, String[] propertyPath) {
        Descriptor messageDescriptor = entityType;
        for (int i = 0; i < propertyPath.length; ++i) {
            String property = propertyPath[i];
            FieldDescriptor field = messageDescriptor.findFieldByName(property);
            if (field != null) {
                if (field.isRepeated()) {
                    return true;
                }
                if (field.getJavaType() != JavaType.MESSAGE) continue;
                messageDescriptor = field.getMessageType();
                continue;
            }
            if (i == 0 && (messageDescriptor = this.indexedFieldProvider.get(messageDescriptor).keyType(property)) != null) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean hasProperty(Descriptor entityType, String[] propertyPath) {
        if (propertyPath.length == 1 && (propertyPath[0].equals(VERSION) || propertyPath[0].equals(VALUE) || propertyPath[0].equals(SCORE))) {
            return true;
        }
        return this.getField(entityType, propertyPath) != null;
    }

    @Override
    public boolean hasEmbeddedProperty(Descriptor entityType, String[] propertyPath) {
        FieldDescriptor field = this.getField(entityType, propertyPath);
        if (field == null) {
            return false;
        }
        return field.getJavaType() == JavaType.MESSAGE;
    }

    @Override
    public Object convertToPropertyType(Descriptor entityType, String[] propertyPath, String value) {
        FieldDescriptor field = this.getField(entityType, propertyPath);
        if (field == null) {
            return super.convertToPropertyType(entityType, propertyPath, value);
        }
        if (field.getJavaType() == JavaType.BOOLEAN) {
            try {
                return Integer.parseInt(value) != 0;
            }
            catch (NumberFormatException e) {
                return super.convertToPropertyType(entityType, propertyPath, value);
            }
        }
        if (field.getJavaType() == JavaType.ENUM) {
            EnumValueDescriptor enumValue;
            EnumDescriptor enumType = field.getEnumType();
            try {
                enumValue = enumType.findValueByNumber(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                enumValue = enumType.findValueByName(value);
            }
            if (enumValue == null) {
                throw log.getInvalidEnumLiteralException(value, enumType.getFullName());
            }
            return enumValue.getNumber();
        }
        if (field.getJavaType() == JavaType.MESSAGE) {
            if (field.getTypeName().equals(BIG_INTEGER_COMMON_TYPE)) {
                return new BigInteger(value);
            }
            if (field.getTypeName().equals(BIG_DECIMAL_COMMON_TYPE)) {
                return new BigDecimal(value);
            }
        }
        return super.convertToPropertyType(entityType, propertyPath, value);
    }

    public static FieldDescriptor syntheticKeyField(String name, String type) {
        return new FieldDescriptor.Builder().withName(name).withNumber(150003).withTypeName(type).build();
    }
}

