/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax.parser;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.infinispan.query.objectfilter.impl.logging.Log;
import org.infinispan.query.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.query.objectfilter.impl.ql.PropertyPath;
import org.infinispan.query.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.jboss.logging.Logger;

public class AggregationPropertyPath<TypeMetadata>
extends PropertyPath<TypeDescriptor<TypeMetadata>> {
    private static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)AggregationPropertyPath.class.getName());
    private final AggregationFunction aggregationFunction;

    AggregationPropertyPath(AggregationFunction aggregationFunction, List<PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>> path) {
        super(path);
        switch (aggregationFunction) {
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case COUNT: {
                break;
            }
            default: {
                throw log.aggregationTypeNotSupportedException(aggregationFunction.name());
            }
        }
        this.aggregationFunction = aggregationFunction;
    }

    public AggregationFunction getAggregationFunction() {
        return this.aggregationFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AggregationPropertyPath that = (AggregationPropertyPath)o;
        return this.aggregationFunction == that.aggregationFunction;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.aggregationFunction.hashCode();
    }

    @Override
    public String toString() {
        String stringPath = this.asStringPath();
        if ("__HSearch_This".equals(stringPath)) {
            stringPath = "*";
        }
        return this.aggregationFunction.name() + "(" + stringPath + ")";
    }
}

