/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax;

import org.infinispan.query.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.query.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.Visitor;

public final class ComparisonExpr
implements PrimaryPredicateExpr {
    private final ValueExpr leftChild;
    private final ValueExpr rightChild;
    private final Type type;

    public ComparisonExpr(ValueExpr leftChild, ValueExpr rightChild, Type type) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.type = type;
    }

    public ValueExpr getLeftChild() {
        return this.leftChild;
    }

    public ValueExpr getRightChild() {
        return this.rightChild;
    }

    public Type getComparisonType() {
        return this.type;
    }

    @Override
    public ValueExpr getChild() {
        return this.leftChild;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpr other = (ComparisonExpr)o;
        return this.type == other.type && this.leftChild.equals(other.leftChild) && this.rightChild.equals(other.rightChild);
    }

    public int hashCode() {
        int result = 31 * this.leftChild.hashCode() + this.rightChild.hashCode();
        return 31 * result + this.type.hashCode();
    }

    public String toString() {
        return String.valueOf((Object)this.type) + "(" + String.valueOf(this.leftChild) + ", " + String.valueOf(this.rightChild) + ")";
    }

    @Override
    public void appendQueryString(StringBuilder sb) {
        this.leftChild.appendQueryString(sb);
        sb.append(' ');
        switch (this.type.ordinal()) {
            case 0: {
                sb.append('<');
                break;
            }
            case 1: {
                sb.append("<=");
                break;
            }
            case 2: {
                sb.append('=');
                break;
            }
            case 3: {
                sb.append("!=");
                break;
            }
            case 4: {
                sb.append(">=");
                break;
            }
            case 5: {
                sb.append('>');
            }
        }
        sb.append(' ');
        this.rightChild.appendQueryString(sb);
    }

    public static enum Type {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER;


        public Type negate() {
            return switch (this.ordinal()) {
                case 0 -> GREATER_OR_EQUAL;
                case 1 -> GREATER;
                case 2 -> NOT_EQUAL;
                case 3 -> EQUAL;
                case 4 -> LESS;
                case 5 -> LESS_OR_EQUAL;
                default -> this;
            };
        }

        public Type reverse() {
            return switch (this.ordinal()) {
                case 0 -> GREATER;
                case 5 -> LESS;
                case 1 -> GREATER_OR_EQUAL;
                case 4 -> LESS_OR_EQUAL;
                default -> this;
            };
        }
    }
}

