/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.predicateindex;

import java.util.List;
import org.infinispan.query.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.query.objectfilter.impl.MetadataAdapter;
import org.infinispan.query.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.query.objectfilter.impl.predicateindex.Predicates;
import org.infinispan.query.objectfilter.impl.predicateindex.RootNode;
import org.infinispan.query.objectfilter.impl.predicateindex.be.PredicateNode;

public final class PredicateIndex<AttributeMetadata, AttributeId extends Comparable<AttributeId>> {
    private final AttributeNode<AttributeMetadata, AttributeId> root;

    public PredicateIndex(MetadataAdapter<?, AttributeMetadata, AttributeId> metadataAdapter) {
        this.root = new RootNode<AttributeMetadata, AttributeId>(metadataAdapter);
    }

    public AttributeNode<AttributeMetadata, AttributeId> getRoot() {
        return this.root;
    }

    public Predicates.Subscription<AttributeId> addSubscriptionForPredicate(PredicateNode<AttributeId> predicateNode, FilterSubscriptionImpl filterSubscription) {
        AttributeNode<AttributeMetadata, AttributeId> attributeNode;
        predicateNode.getPredicate().attributeNode = attributeNode = this.addAttributeNodeByPath(predicateNode.getAttributePath());
        return attributeNode.addPredicateSubscription(predicateNode, filterSubscription);
    }

    public void removeSubscriptionForPredicate(Predicates.Subscription<AttributeId> subscription) {
        AttributeNode<AttributeMetadata, AttributeId> current;
        current.removePredicateSubscription(subscription);
        for (current = this.getAttributeNodeByPath(subscription.getPredicateNode().getAttributePath()); current != this.root && current.getNumChildren() <= 0 && !current.hasPredicates() && !current.hasProjections(); current = current.getParent()) {
            AttributeId childId = current.getAttribute();
            current.removeChild(childId);
        }
    }

    private AttributeNode<AttributeMetadata, AttributeId> getAttributeNodeByPath(List<AttributeId> attributePath) {
        AttributeNode<AttributeMetadata, Comparable> node = this.root;
        for (Comparable attribute : attributePath) {
            if ((node = node.getChild(attribute)) != null) continue;
            throw new IllegalStateException("Child not found : " + String.valueOf(attribute));
        }
        return node;
    }

    private AttributeNode<AttributeMetadata, AttributeId> addAttributeNodeByPath(List<AttributeId> attributePath) {
        AttributeNode<AttributeMetadata, Comparable> node = this.root;
        for (Comparable attribute : attributePath) {
            node = node.addChild(attribute);
        }
        return node;
    }

    public int addProjections(FilterSubscriptionImpl<?, AttributeMetadata, AttributeId> filterSubscription, List<List<AttributeId>> projection, int i) {
        for (List<AttributeId> projectionPath : projection) {
            AttributeNode<AttributeMetadata, AttributeId> node = this.addAttributeNodeByPath(projectionPath);
            node.addProjection(filterSubscription, i++);
        }
        return i;
    }

    public void removeProjections(FilterSubscriptionImpl<?, AttributeMetadata, AttributeId> filterSubscription, List<List<AttributeId>> projection) {
        for (List<AttributeId> projectionPath : projection) {
            AttributeNode<AttributeMetadata, AttributeId> node = this.getAttributeNodeByPath(projectionPath);
            node.removeProjections(filterSubscription);
        }
    }
}

