/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.mapper.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.infinispan.query.mapper.mapping.impl.InfinispanIndexedTypeContextImpl;
import org.infinispan.query.mapper.session.impl.InfinispanTypeContextProvider;

class InfinispanTypeContextContainer
implements InfinispanTypeContextProvider {
    private final Map<String, InfinispanIndexedTypeContextImpl<?>> indexedTypeContextsByEntityName = new LinkedHashMap();
    private final Map<Class<?>, InfinispanIndexedTypeContextImpl<?>> indexedTypeContextsByJavaType = new LinkedHashMap();

    private InfinispanTypeContextContainer(Builder builder) {
        for (InfinispanIndexedTypeContextImpl.Builder<?> contextBuilder : builder.indexedTypeContextBuilders) {
            InfinispanIndexedTypeContextImpl<?> indexedTypeContext = contextBuilder.build();
            this.indexedTypeContextsByEntityName.put(indexedTypeContext.name(), indexedTypeContext);
            if (indexedTypeContext.typeIdentifier().isNamed()) continue;
            this.indexedTypeContextsByJavaType.put(indexedTypeContext.typeIdentifier().javaClass(), indexedTypeContext);
        }
    }

    public <E> InfinispanIndexedTypeContextImpl<E> indexedForExactType(Class<E> entityType) {
        return this.indexedTypeContextsByJavaType.get(entityType);
    }

    public InfinispanIndexedTypeContextImpl<?> indexedForEntityName(String indexName) {
        return this.indexedTypeContextsByEntityName.get(indexName);
    }

    @Override
    public Collection<PojoRawTypeIdentifier<?>> allTypeIdentifiers() {
        return this.indexedTypeContextsByEntityName.values().stream().map(InfinispanIndexedTypeContextImpl::typeIdentifier).collect(Collectors.toList());
    }

    Collection<InfinispanIndexedTypeContextImpl<?>> allIndexed() {
        return this.indexedTypeContextsByEntityName.values();
    }

    static class Builder {
        private final List<InfinispanIndexedTypeContextImpl.Builder<?>> indexedTypeContextBuilders = new ArrayList();

        Builder() {
        }

        <E> InfinispanIndexedTypeContextImpl.Builder<E> addIndexed(PojoRawTypeModel<E> typeModel, String entityName) {
            InfinispanIndexedTypeContextImpl.Builder builder = new InfinispanIndexedTypeContextImpl.Builder(typeModel.typeIdentifier(), entityName);
            this.indexedTypeContextBuilders.add(builder);
            return builder;
        }

        InfinispanTypeContextContainer build() {
            return new InfinispanTypeContextContainer(this);
        }
    }
}

