/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.hibernate.search.engine.Version;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.query.core.stats.IndexInfo;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.QueryStatistics;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.Authorizer;

@MBean(objectName="Statistics", description="Statistics for index based query")
@Scope(value=Scopes.NAMED_CACHE)
public final class InfinispanQueryStatisticsInfo {
    private final QueryStatistics queryStatistics;
    private final IndexStatistics indexStatistics;
    private final Authorizer authorizer;

    InfinispanQueryStatisticsInfo(SearchStatistics searchStatistics, Authorizer authorizer) {
        this.queryStatistics = searchStatistics.getQueryStatistics();
        this.indexStatistics = searchStatistics.getIndexStatistics();
        this.authorizer = authorizer;
    }

    @ManagedOperation(description="Clear all query statistics.", displayName="Clear query statistics.")
    public void clear() {
        this.authorizer.checkPermission(AuthorizationPermission.ADMIN);
        this.queryStatistics.clear();
    }

    @ManagedAttribute(description="Number of queries executed in the local index.", displayName="Local indexed query count.")
    public long getSearchQueryExecutionCount() {
        return this.queryStatistics.getLocalIndexedQueryCount();
    }

    @ManagedAttribute(description="The total time in nanoseconds of all indexed queries.", displayName="Local indexed query total time.")
    public long getSearchQueryTotalTime() {
        return this.queryStatistics.getLocalIndexedQueryTotalTime();
    }

    @ManagedAttribute(description="The time in nanoseconds of the slowest indexed query.", displayName="Local indexed query max time.")
    public long getSearchQueryExecutionMaxTime() {
        return this.queryStatistics.getLocalIndexedQueryMaxTime();
    }

    @ManagedAttribute(description="The average time in nanoseconds of all indexed queries.", displayName="Local indexed query avg time.")
    public long getSearchQueryExecutionAvgTime() {
        return Double.valueOf(this.queryStatistics.getLocalIndexedQueryAvgTime()).longValue();
    }

    @ManagedAttribute(description="The Ickle query string of the slowest indexed query.", displayName="Local slowest query.")
    public String getSearchQueryExecutionMaxTimeQueryString() {
        String query = this.queryStatistics.getSlowestLocalIndexedQuery();
        return query == null ? "" : query;
    }

    @ManagedAttribute(description="The total time to load entities from a Cache after an indexed query.", displayName="Entity loading total time.")
    public long getObjectLoadingTotalTime() {
        return this.queryStatistics.getLoadTotalTime();
    }

    @ManagedAttribute(description="The max time in nanoseconds to load entities from a Cache after an indexed query.", displayName="Entity loading max time.")
    public long getObjectLoadingExecutionMaxTime() {
        return this.queryStatistics.getLoadMaxTime();
    }

    @ManagedAttribute(description=" The average time in nanoseconds to load entities from a Cache after an indexed query.", displayName="Entity loading avg time.")
    public long getObjectLoadingExecutionAvgTime() {
        return Double.valueOf(this.queryStatistics.getLoadAvgTime()).longValue();
    }

    @ManagedAttribute(description="The number of operations to load entities from a Cache after an indexed query.", displayName="Entity loading count.")
    public long getObjectsLoadedCount() {
        return this.queryStatistics.getLoadCount();
    }

    @ManagedAttribute(description="True if the Cache has statistics enabled.", displayName="Statistics enabled.")
    public boolean isStatisticsEnabled() {
        return this.queryStatistics.isEnabled();
    }

    @ManagedAttribute(description="The Hibernate Search version used as query engine for the cache.", displayName="Hibernate Search version.")
    public String getSearchVersion() {
        return Version.versionString();
    }

    @ManagedAttribute(description="The name of all indexed entities configured in the cache. The name of the entity is either the class name annotated with @Index, or the protobuf Message name.", displayName="Indexed entity names")
    public Set<String> getIndexedClassNames() {
        return this.indexStatistics.indexedEntities();
    }

    @ManagedOperation(description="The number of indexed entities for a given entity.", displayName="Indexed entries by entity.")
    public int getNumberOfIndexedEntities(String entity) {
        return this.find(this.blockingIndexInfos(), entity).map(IndexInfo::count).orElse(0L).intValue();
    }

    private Optional<IndexInfo> find(Map<String, IndexInfo> indexInfos, String entity) {
        return indexInfos.entrySet().stream().filter(e -> ((String)e.getKey()).equals(entity)).map(Map.Entry::getValue).findFirst();
    }

    @ManagedOperation(description="The number of indexed entities for all entities.", displayName="Indexed entries by entities.")
    public Map<String, Integer> indexedEntitiesCount() {
        return this.blockingIndexInfos().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)((IndexInfo)e.getValue()).count()));
    }

    @ManagedOperation(description="The index size for a given index name.", displayName="Index size by name.")
    public long getIndexSize(String indexName) {
        return this.find(this.blockingIndexInfos(), indexName).map(IndexInfo::size).orElse(0L);
    }

    @ManagedOperation(description="All index sizes by their names.", displayName="Index sizes by names.")
    public Map<String, Long> indexSizes() {
        return this.blockingIndexInfos().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexInfo)e.getValue()).size()));
    }

    public Json getLegacyQueryStatistics() {
        return Json.object().set("search_query_execution_count", (Object)this.getSearchQueryExecutionCount()).set("search_query_total_time", (Object)this.getSearchQueryTotalTime()).set("search_query_execution_max_time", (Object)this.getSearchQueryExecutionMaxTime()).set("search_query_execution_avg_time", (Object)this.getSearchQueryExecutionAvgTime()).set("object_loading_total_time", (Object)this.getObjectLoadingTotalTime()).set("object_loading_execution_max_time", (Object)this.getObjectLoadingExecutionMaxTime()).set("object_loading_execution_avg_time", (Object)this.getObjectLoadingExecutionAvgTime()).set("objects_loaded_count", (Object)this.getObjectsLoadedCount()).set("search_query_execution_max_time_query_string", (Object)this.getSearchQueryExecutionMaxTimeQueryString());
    }

    public CompletionStage<Json> computeLegacyIndexStatistics() {
        return this.indexStatistics.computeIndexInfos().thenApply(indexInfos -> {
            Map<String, Long> counts = indexInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexInfo)e.getValue()).count()));
            Map<String, Long> sizes = indexInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IndexInfo)e.getValue()).size()));
            return Json.object().set("indexed_class_names", Json.make(indexInfos.keySet())).set("indexed_entities_count", Json.make(counts)).set("index_sizes", Json.make(sizes)).set("reindexing", (Object)this.indexStatistics.reindexing());
        });
    }

    private Map<String, IndexInfo> blockingIndexInfos() {
        return (Map)CompletionStages.join(this.indexStatistics.computeIndexInfos());
    }
}

