/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl.continuous;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.AbstractCacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.core.impl.QueryCache;
import org.infinispan.query.core.impl.continuous.ContinuousQueryResult;
import org.infinispan.query.objectfilter.Matcher;
import org.infinispan.query.objectfilter.ObjectFilter;

@ProtoTypeId(value=4212)
@Scope(value=Scopes.NONE)
public class IckleContinuousQueryCacheEventFilterConverter<K, V, C>
extends AbstractCacheEventFilterConverter<K, V, C>
implements IndexedFilter<K, V, C> {
    protected final String queryString;
    protected final Map<String, Object> namedParameters;
    protected Class<? extends Matcher> matcherImplClass;
    protected String cacheName;
    protected QueryCache queryCache;
    protected Matcher matcher;
    protected ObjectFilter objectFilter;

    public IckleContinuousQueryCacheEventFilterConverter(String queryString, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (queryString == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.queryString = queryString;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    @ProtoFactory
    protected IckleContinuousQueryCacheEventFilterConverter(String queryString, MarshallableMap<String, Object> wrappedNamedParameters, Class<? extends Matcher> matcherImplClass) {
        this(queryString, MarshallableMap.unwrap(wrappedNamedParameters), matcherImplClass);
    }

    @ProtoField(value=1)
    public String getQueryString() {
        return this.queryString;
    }

    @ProtoField(number=2, name="namedParameters")
    public MarshallableMap<String, Object> getWrappedNamedParameters() {
        return MarshallableMap.create(this.namedParameters);
    }

    @ProtoField(value=3)
    public Class<? extends Matcher> getMatcherImplClass() {
        return this.matcherImplClass;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    @Inject
    protected void injectDependencies(Cache<?, ?> cache) {
        this.cacheName = cache.getName();
        ComponentRegistry componentRegistry = ComponentRegistry.of(cache);
        this.queryCache = (QueryCache)componentRegistry.getComponent(QueryCache.class);
        this.matcher = (Matcher)componentRegistry.getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    protected ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            this.objectFilter = this.queryCache != null ? this.queryCache.get(this.cacheName, this.queryString, null, this.matcherImplClass, (qs, accumulators) -> this.matcher.getObjectFilter(qs)) : this.matcher.getObjectFilter(this.queryString);
        }
        return this.namedParameters != null ? this.objectFilter.withParameters(this.namedParameters) : this.objectFilter;
    }

    public C filterAndConvert(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
        ObjectFilter.FilterResult f2;
        if (eventType.isExpired()) {
            oldValue = newValue;
            newValue = null;
        }
        ObjectFilter objectFilter = this.getObjectFilter();
        ObjectFilter.FilterResult f1 = oldValue == null ? null : objectFilter.filter(key, oldValue, oldMetadata);
        ObjectFilter.FilterResult filterResult = f2 = newValue == null ? null : objectFilter.filter(key, newValue, newMetadata);
        if (f1 == null) {
            if (f2 != null) {
                return (C)new ContinuousQueryResult<V>(ContinuousQueryResult.ResultType.JOINING, f2.getProjection() == null ? newValue : null, f2.getProjection());
            }
        } else {
            if (f2 != null) {
                return (C)new ContinuousQueryResult<V>(ContinuousQueryResult.ResultType.UPDATED, f2.getProjection() == null ? newValue : null, f2.getProjection());
            }
            return (C)new ContinuousQueryResult<Object>(ContinuousQueryResult.ResultType.LEAVING, null, null);
        }
        return null;
    }

    public String toString() {
        return "IckleContinuousQueryCacheEventFilterConverter{queryString='" + this.queryString + "'}";
    }
}

