/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.infinispan.query.objectfilter.impl.aggregation.FieldAccumulator;

public final class RowGrouper {
    private final int noOfGroupingColumns;
    private final FieldAccumulator[] accumulators;
    private final boolean twoPhaseAcc;
    private final int inRowLength;
    private final int outRowLength;
    private final LinkedHashMap<GroupRowKey, Object[]> groups;
    private final Object[] globalGroup;

    public RowGrouper(int noOfGroupingColumns, FieldAccumulator[] accumulators, boolean twoPhaseAcc) {
        this.noOfGroupingColumns = noOfGroupingColumns;
        this.accumulators = accumulators != null && accumulators.length != 0 ? accumulators : null;
        this.twoPhaseAcc = twoPhaseAcc;
        this.inRowLength = this.findInRowLength(noOfGroupingColumns, accumulators);
        if (this.inRowLength == 0) {
            throw new IllegalArgumentException("Must have at least one grouping or aggregated column");
        }
        this.outRowLength = noOfGroupingColumns + (accumulators != null ? accumulators.length : 0);
        if (noOfGroupingColumns > 0) {
            this.groups = new LinkedHashMap();
            this.globalGroup = null;
        } else {
            this.groups = null;
            this.globalGroup = new Object[this.outRowLength];
            for (FieldAccumulator acc : accumulators) {
                acc.init(this.globalGroup);
            }
        }
    }

    private int findInRowLength(int noOfGroupingColumns, FieldAccumulator[] accumulators) {
        int l = noOfGroupingColumns;
        if (accumulators != null) {
            for (FieldAccumulator acc : accumulators) {
                if (acc.inPos + 1 <= l) continue;
                l = acc.inPos + 1;
            }
        }
        return l;
    }

    public void addRow(Object[] row) {
        if (row.length != this.inRowLength) {
            throw new IllegalArgumentException("Row length mismatch");
        }
        if (this.noOfGroupingColumns > 0) {
            GroupRowKey groupRowKey = new GroupRowKey(row);
            Object[] existingGroup = this.groups.get(groupRowKey);
            if (existingGroup == null) {
                existingGroup = new Object[this.outRowLength];
                System.arraycopy(row, 0, existingGroup, 0, this.noOfGroupingColumns);
                if (this.accumulators != null) {
                    FieldAccumulator.init(existingGroup, this.accumulators);
                    for (FieldAccumulator acc : this.accumulators) {
                        acc.init(existingGroup);
                    }
                }
                this.groups.put(groupRowKey, existingGroup);
            }
            if (this.accumulators != null) {
                if (this.twoPhaseAcc) {
                    FieldAccumulator.merge(row, existingGroup, this.accumulators);
                } else {
                    FieldAccumulator.update(row, existingGroup, this.accumulators);
                }
            }
        } else if (this.twoPhaseAcc) {
            FieldAccumulator.merge(row, this.globalGroup, this.accumulators);
        } else {
            FieldAccumulator.update(row, this.globalGroup, this.accumulators);
        }
    }

    public Iterator<Object[]> finish() {
        if (this.groups != null) {
            return new Iterator<Object[]>(){
                private final Iterator<Object[]> iterator;
                {
                    this.iterator = RowGrouper.this.groups.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    Object[] row = this.iterator.next();
                    if (RowGrouper.this.accumulators != null) {
                        FieldAccumulator.finish(row, RowGrouper.this.accumulators);
                    }
                    return row;
                }
            };
        }
        FieldAccumulator.finish(this.globalGroup, this.accumulators);
        return Collections.singleton(this.globalGroup).iterator();
    }

    public String toString() {
        return "RowGrouper{noOfGroupingColumns=" + this.noOfGroupingColumns + ", inRowLength=" + this.inRowLength + ", outRowLength=" + this.outRowLength + ", accumulators=" + Arrays.toString(this.accumulators) + ", number of groups=" + this.groups.size() + "}";
    }

    private final class GroupRowKey {
        private final Object[] row;

        GroupRowKey(Object[] row) {
            this.row = row;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupRowKey other = (GroupRowKey)o;
            int n = RowGrouper.this.noOfGroupingColumns > 0 ? RowGrouper.this.noOfGroupingColumns : this.row.length;
            for (int i = 0; i < n; ++i) {
                Object o1 = this.row[i];
                Object o2 = other.row[i];
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            int n = RowGrouper.this.noOfGroupingColumns > 0 ? RowGrouper.this.noOfGroupingColumns : this.row.length;
            for (int i = 0; i < n; ++i) {
                Object e = this.row[i];
                result = 31 * result + (e == null ? 0 : e.hashCode());
            }
            return result;
        }
    }
}

