/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.aggregation;

final class DoubleStat {
    private long count;
    private double sum;
    private double sumCompensation;
    private double simpleSum;

    DoubleStat() {
    }

    void update(double value) {
        this.update(value, 1L);
    }

    void update(double value, long count) {
        this.count += count;
        this.simpleSum += value;
        double tmp = value - this.sumCompensation;
        double velvel = this.sum + tmp;
        this.sumCompensation = velvel - this.sum - tmp;
        this.sum = velvel;
    }

    Double getSum() {
        if (this.count == 0L) {
            return null;
        }
        double tmp = this.sum + this.sumCompensation;
        if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSum)) {
            return this.simpleSum;
        }
        return tmp;
    }

    Double getAvg() {
        return this.count == 0L ? null : Double.valueOf(this.getSum() / (double)this.count);
    }

    long getCount() {
        return this.count;
    }
}

