/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.mapper.mapping.metamodel;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexObjectFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexObjectFieldTypeDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.query.mapper.mapping.metamodel.ValueFieldMetamodel;

public class ObjectFieldMetamodel
implements JsonSerialization {
    private final boolean multiValued;
    private final boolean multiValuedInRoot;
    private final boolean nested;
    private final Map<String, ValueFieldMetamodel> valueFields = new LinkedHashMap<String, ValueFieldMetamodel>();
    private final Map<String, ObjectFieldMetamodel> objectFields = new LinkedHashMap<String, ObjectFieldMetamodel>();

    public ObjectFieldMetamodel(boolean multiValued, boolean multiValuedInRoot, IndexObjectFieldDescriptor descriptor) {
        this.multiValued = multiValued;
        this.multiValuedInRoot = multiValuedInRoot;
        IndexObjectFieldTypeDescriptor type = descriptor.type();
        this.nested = type.nested();
        for (IndexFieldDescriptor field : descriptor.staticChildren()) {
            String name = field.relativeName();
            boolean fieldMultiValued = field.multiValued();
            boolean fieldMultiValuedInRoot = field.multiValuedInRoot();
            if (field.isValueField()) {
                IndexValueFieldDescriptor valueField = field.toValueField();
                IndexValueFieldTypeDescriptor fieldType = valueField.type();
                this.valueFields.put(name, new ValueFieldMetamodel(fieldMultiValued, fieldMultiValuedInRoot, fieldType));
                continue;
            }
            if (!field.isObjectField()) continue;
            this.objectFields.put(name, new ObjectFieldMetamodel(fieldMultiValued, fieldMultiValuedInRoot, field.toObjectField()));
        }
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isMultiValuedInRoot() {
        return this.multiValuedInRoot;
    }

    public boolean isNested() {
        return this.nested;
    }

    public Map<String, ValueFieldMetamodel> getValueFields() {
        return this.valueFields;
    }

    public Map<String, ObjectFieldMetamodel> getObjectFields() {
        return this.objectFields;
    }

    public Json toJson() {
        Json object = Json.object((Object[])new Object[]{"multi-valued", this.multiValued, "multi-valued-in-root", this.multiValuedInRoot, "nested", this.nested});
        if (!this.valueFields.isEmpty()) {
            object.set("value-fields", Json.make(this.valueFields));
        }
        if (!this.objectFields.isEmpty()) {
            object.set("object-fields", Json.make(this.objectFields));
        }
        return object;
    }
}

