/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.BitSet;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQCommandType;
import org.infinispan.query.impl.QueryDefinition;

@ProtoTypeId(value=4208)
public final class ClusteredQueryOperation {
    @ProtoField(value=1)
    final CQCommandType commandType;
    @ProtoField(value=2)
    final QueryDefinition queryDefinition;
    @ProtoField(value=3)
    final UUID queryId;
    @ProtoField(value=4)
    final int docIndex;

    @ProtoFactory
    ClusteredQueryOperation(CQCommandType commandType, QueryDefinition queryDefinition, UUID queryId, int docIndex) {
        this.commandType = commandType;
        this.queryDefinition = queryDefinition;
        this.queryId = queryId;
        this.docIndex = docIndex;
    }

    private ClusteredQueryOperation(CQCommandType commandType, QueryDefinition queryDefinition) {
        this(commandType, queryDefinition, null, 0);
    }

    public QueryDefinition getQueryDefinition() {
        return this.queryDefinition;
    }

    static ClusteredQueryOperation getResultSize(QueryDefinition queryDefinition) {
        return new ClusteredQueryOperation(CQCommandType.GET_RESULT_SIZE, queryDefinition);
    }

    static ClusteredQueryOperation delete(QueryDefinition queryDefinition) {
        return new ClusteredQueryOperation(CQCommandType.DELETE, queryDefinition);
    }

    static ClusteredQueryOperation createEagerIterator(QueryDefinition queryDefinition) {
        return new ClusteredQueryOperation(CQCommandType.CREATE_EAGER_ITERATOR, queryDefinition);
    }

    public CompletionStage<QueryResponse> perform(Cache<?, ?> cache, BitSet segments) {
        return this.commandType.perform(cache.getAdvancedCache(), this.queryDefinition, this.queryId, this.docIndex, segments);
    }
}

