/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.syntax;

import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.infinispan.query.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.query.objectfilter.impl.syntax.Visitor;
import org.infinispan.query.objectfilter.impl.util.DateHelper;

public final class ConstantValueExpr
implements ValueExpr {
    private final Comparable constantValue;

    public ConstantValueExpr(Comparable constantValue) {
        if (constantValue == null) {
            throw new IllegalArgumentException("constantValue cannot be null");
        }
        this.constantValue = constantValue;
    }

    public Comparable getConstantValue() {
        if (this.isParameter()) {
            throw new IllegalStateException("The value is a parameter " + String.valueOf(this.constantValue));
        }
        return this.constantValue;
    }

    public boolean isParameter() {
        return this.constantValue instanceof ParamPlaceholder;
    }

    public Comparable getConstantValueAs(Class<?> targetType, Map<String, Object> namedParameters) {
        Class<?> type;
        Comparable value;
        if (this.constantValue instanceof ParamPlaceholder) {
            String paramName = ((ParamPlaceholder)this.constantValue).getName();
            if (namedParameters == null) {
                throw new IllegalStateException("Missing value for parameter " + paramName);
            }
            value = (Comparable)namedParameters.get(paramName);
            if (value == null) {
                throw new IllegalStateException("Missing value for parameter " + paramName);
            }
        } else {
            value = this.constantValue;
        }
        if ((type = value.getClass()) != targetType) {
            if (targetType == String.class) {
                return value.toString();
            }
            if (targetType == Boolean.class) {
                if (type == String.class) {
                    return Boolean.valueOf((String)((Object)value));
                }
            } else if (targetType == Double.class) {
                if (type == String.class) {
                    return Double.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Double.valueOf(((Number)((Object)value)).doubleValue());
                }
            } else if (targetType == Float.class) {
                if (type == String.class) {
                    return Float.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Float.valueOf(((Number)((Object)value)).floatValue());
                }
            } else if (targetType == Long.class) {
                if (type == String.class) {
                    return Long.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Long.valueOf(((Number)((Object)value)).longValue());
                }
            } else if (targetType == Integer.class) {
                if (type == String.class) {
                    return Integer.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Integer.valueOf(((Number)((Object)value)).intValue());
                }
            } else if (targetType == Short.class) {
                if (type == String.class) {
                    return Short.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Short.valueOf(((Number)((Object)value)).shortValue());
                }
            } else if (targetType == Byte.class) {
                if (type == String.class) {
                    return Byte.valueOf((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Byte.valueOf(((Number)((Object)value)).byteValue());
                }
            } else if (targetType == Date.class) {
                if (type == String.class) {
                    try {
                        return DateHelper.JPA_DATE_FORMAT.parse((String)((Object)value));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (Number.class.isAssignableFrom(type)) {
                    return new Date(((Number)((Object)value)).longValue());
                }
            } else if (targetType == Instant.class) {
                if (type == String.class) {
                    return Instant.parse((String)((Object)value));
                }
                if (Number.class.isAssignableFrom(type)) {
                    return Instant.ofEpochMilli(((Number)((Object)value)).longValue());
                }
            }
        }
        return value;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantValueExpr other = (ConstantValueExpr)o;
        return this.constantValue.equals(other.constantValue);
    }

    public int hashCode() {
        return this.constantValue.hashCode();
    }

    public String toString() {
        Object strVal = this.constantValue instanceof ParamPlaceholder ? this.constantValue.toString() : (this.constantValue instanceof String ? "\"" + String.valueOf(this.constantValue) + "\"" : (this.constantValue instanceof Character ? "'" + String.valueOf(this.constantValue) + "'" : (this.constantValue instanceof Date ? DateHelper.JPA_DATE_FORMAT.format((Date)this.constantValue) : (this.constantValue instanceof Instant ? this.constantValue.toString() : String.valueOf(this.constantValue)))));
        return "CONST(" + (String)strVal + ")";
    }

    @Override
    public void appendQueryString(StringBuilder sb) {
        if (this.constantValue instanceof ParamPlaceholder) {
            sb.append(this.constantValue);
        } else if (this.constantValue instanceof String) {
            sb.append("\"").append(this.constantValue).append("\"");
        } else if (this.constantValue instanceof Character) {
            sb.append("'").append(this.constantValue).append("'");
        } else if (this.constantValue instanceof Date) {
            sb.append("'").append(DateHelper.JPA_DATE_FORMAT.format((Date)this.constantValue)).append("'");
        } else if (this.constantValue instanceof Instant) {
            sb.append("'").append(this.constantValue).append("'");
        } else {
            sb.append(this.constantValue);
        }
    }

    public static final class ParamPlaceholder
    implements Comparable {
        private final String name;

        public ParamPlaceholder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name cannot be null");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return ":" + this.getName();
        }

        public int compareTo(Object o) {
            return this.name.compareTo(((ParamPlaceholder)o).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == ParamPlaceholder.class && this.name.equals(((ParamPlaceholder)obj).getName());
        }
    }
}

