/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.objectfilter.impl.aggregation;

import java.lang.invoke.MethodHandles;
import org.infinispan.query.objectfilter.impl.aggregation.DoubleStat;
import org.infinispan.query.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.query.objectfilter.impl.logging.Log;
import org.jboss.logging.Logger;

final class AvgAccumulator
extends FieldAccumulator {
    private static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)AvgAccumulator.class.getName());

    AvgAccumulator(int inPos, int outPos, Class<?> fieldType) {
        super(inPos, outPos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw log.getAVGCannotBeAppliedToPropertyOfType(fieldType.getName());
        }
    }

    @Override
    public void init(Object[] accRow) {
        accRow[this.outPos] = new DoubleStat();
    }

    @Override
    public void update(Object[] accRow, Object value) {
        if (value != null) {
            ((DoubleStat)accRow[this.outPos]).update(((Number)value).doubleValue());
        }
    }

    @Override
    protected void merge(Object[] accRow, Object value) {
        if (value instanceof DoubleStat) {
            DoubleStat avgVal = (DoubleStat)value;
            if (avgVal.getCount() > 0L) {
                ((DoubleStat)accRow[this.outPos]).update(avgVal.getSum(), avgVal.getCount());
            }
        } else {
            this.update(accRow, value);
        }
    }

    @Override
    protected void finish(Object[] accRow) {
        accRow[this.outPos] = ((DoubleStat)accRow[this.outPos]).getAvg();
    }
}

