/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
@Scope(value=Scopes.GLOBAL)
public final class QueryCache {
    private static final Log log = (Log)LogFactory.getLog(QueryCache.class, Log.class);
    public static final String QUERY_CACHE_NAME = "___query_cache";
    private static final long MAX_ENTRIES = 200L;
    private static final long ENTRY_LIFESPAN = 300L;
    @Inject
    EmbeddedCacheManager cacheManager;
    private volatile Cache<QueryCacheKey, Object> cache;

    public <T> T get(String cacheName, String queryString, List<FieldAccumulator> accumulators, Object queryTypeDiscriminator, QueryCreator<T> queryCreator) {
        QueryCacheKey key = new QueryCacheKey(cacheName, queryString, accumulators, queryTypeDiscriminator);
        return (T)this.getCache().computeIfAbsent((Object)key, (SerializableFunction & Serializable)k -> queryCreator.create(k.queryString, k.accumulators));
    }

    public void clear() {
        log.debug("Clearing query cache for all caches");
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public void clear(String cacheName) {
        log.debugf("Clearing query cache for cache %s", cacheName);
        if (this.cache != null) {
            this.cache.keySet().removeIf(k -> k.cacheName.equals(cacheName));
        }
    }

    private Cache<QueryCacheKey, Object> getCache() {
        if (this.cache == null) {
            this.cache = this.cacheManager.getCache(QUERY_CACHE_NAME);
        }
        return this.cache;
    }

    public static ConfigurationBuilder getQueryCacheConfig() {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.simpleCache(true).expiration().maxIdle(300L, TimeUnit.SECONDS).memory().maxCount(200L);
        return cfgBuilder;
    }

    private record QueryCacheKey(String cacheName, String queryString, List<FieldAccumulator> accumulators, Object queryTypeDiscriminator) {
    }

    @FunctionalInterface
    public static interface QueryCreator<Q> {
        public Q create(String var1, List<FieldAccumulator> var2);
    }
}

