/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.BitSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.clustered.ClusteredQueryOperation;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=4223)
public class SegmentsClusteredQueryCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final ClusteredQueryOperation clusteredQueryOperation;
    @ProtoField(value=3)
    BitSet segments;

    @ProtoFactory
    SegmentsClusteredQueryCommand(ByteString cacheName, ClusteredQueryOperation clusteredQueryOperation, BitSet segments) {
        super(cacheName);
        this.clusteredQueryOperation = clusteredQueryOperation;
        this.segments = segments;
    }

    public SegmentsClusteredQueryCommand(String cacheName, ClusteredQueryOperation clusteredQueryOperation, BitSet segments) {
        super(ByteString.fromString((String)cacheName));
        this.clusteredQueryOperation = clusteredQueryOperation;
        this.segments = segments;
    }

    public void setSegments(BitSet segments) {
        this.segments = segments;
    }

    public BitSet getSegments() {
        return this.segments;
    }

    public CompletionStage<QueryResponse> perform(Cache<?, ?> cache) {
        return this.clusteredQueryOperation.perform(cache, this.segments);
    }

    public boolean isReturnValueExpected() {
        return true;
    }

    public CompletableFuture<?> invokeAsync(ComponentRegistry componentRegistry) {
        AdvancedCache cache = (AdvancedCache)componentRegistry.getCache().wired();
        return this.perform((Cache<?, ?>)cache).toCompletableFuture();
    }

    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

