/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.query.Indexer;
import org.infinispan.query.core.impl.Log;
import org.infinispan.query.impl.massindex.IndexLock;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.IndexWorker;
import org.infinispan.query.impl.massindex.MassIndexerAlreadyStartedException;
import org.infinispan.query.impl.massindex.MassIndexerLockFactory;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="MassIndexer", description="Component that rebuilds the Lucene index from the cached data")
@Scope(value=Scopes.NAMED_CACHE)
public class DistributedExecutorMassIndexer
implements Indexer {
    private static final Log LOG = (Log)LogFactory.getLog(DistributedExecutorMassIndexer.class, Log.class);
    private final AdvancedCache<?, ?> cache;
    private final IndexUpdater indexUpdater;
    private final ClusterExecutor executor;
    private final IndexLock lock;
    private final Authorizer authorizer;
    private volatile boolean isRunning = false;
    private static final TriConsumer<Address, Void, Throwable> TRI_CONSUMER = (a, v, t) -> {
        if (t != null) {
            throw new CacheException(t);
        }
    };

    public DistributedExecutorMassIndexer(AdvancedCache<?, ?> cache) {
        this.cache = cache;
        this.indexUpdater = new IndexUpdater(cache);
        this.executor = cache.getCacheManager().executor();
        this.lock = MassIndexerLockFactory.buildLock(cache);
        this.authorizer = (Authorizer)ComponentRegistry.componentOf(cache, Authorizer.class);
    }

    @ManagedOperation(description="Starts rebuilding the index", displayName="Rebuild index")
    public void start() {
        CompletionStages.join(this.executeInternal(false, false, new Class[0]));
    }

    @Override
    public CompletionStage<Void> run() {
        return this.executeInternal(false, false, new Class[0]).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> runLocal() {
        return this.executeInternal(false, true, new Class[0]).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> run(Object ... keys) {
        this.authorizer.checkPermission(AuthorizationPermission.ADMIN);
        CompletableFuture future = null;
        HashSet<Object> keySet = new HashSet<Object>();
        for (Object key : keys) {
            if (this.cache.containsKey(key)) {
                keySet.add(key);
                continue;
            }
            LOG.warn((Object)"cache contains no mapping for the key");
        }
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
        };
        if (!keySet.isEmpty()) {
            IndexWorker indexWorker = new IndexWorker(this.cache.getName(), null, false, keySet);
            future = this.executor.submitConsumer((Function)indexWorker, triConsumer);
        }
        return future != null ? future : CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> remove() {
        return this.executeInternal(true, false, new Class[0]).toCompletableFuture();
    }

    @Override
    public CompletionStage<Void> remove(Class<?> ... entities) {
        return this.executeInternal(true, false, entities);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private CompletionStage<Void> executeInternal(boolean skipIndex, boolean local, Class<?> ... entities) {
        this.authorizer.checkPermission(AuthorizationPermission.ADMIN);
        CompletionStage<Boolean> lockStage = this.lock.lock();
        return lockStage.thenCompose(acquired -> {
            if (!acquired.booleanValue()) {
                return CompletableFuture.failedFuture(new MassIndexerAlreadyStartedException());
            }
            try {
                this.isRunning = true;
                List<Class<?>> javaClasses = entities.length == 0 ? this.indexUpdater.allJavaClasses() : Arrays.asList(entities);
                IndexWorker indexWork = new IndexWorker(this.cache.getName(), javaClasses, skipIndex, (Set<Object>)null);
                ClusterExecutor clusterExecutor = this.executor.timeout(Long.MAX_VALUE, TimeUnit.SECONDS);
                if (local) {
                    clusterExecutor = clusterExecutor.filterTargets(a -> a.equals((Object)this.cache.getRpcManager().getAddress()));
                }
                CompletableFuture completableFuture = clusterExecutor.timeout(Long.MAX_VALUE, TimeUnit.SECONDS).submitConsumer((Function)indexWork, TRI_CONSUMER);
                return completableFuture;
            }
            catch (Throwable t) {
                CompletableFuture completableFuture = CompletableFuture.failedFuture(t);
                return completableFuture;
            }
            finally {
                this.lock.unlock();
                this.isRunning = false;
            }
        });
    }
}

