/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered.commandworkers;

import java.util.BitSet;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.protostream.annotations.Proto;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.query.clustered.commandworkers.CQCreateEagerQuery;
import org.infinispan.query.clustered.commandworkers.CQDelete;
import org.infinispan.query.clustered.commandworkers.CQGetResultSize;
import org.infinispan.query.clustered.commandworkers.CQWorker;
import org.infinispan.query.impl.QueryDefinition;

@Proto
@ProtoTypeId(value=4209)
public enum CQCommandType {
    CREATE_EAGER_ITERATOR(CQCreateEagerQuery::new),
    GET_RESULT_SIZE(CQGetResultSize::new),
    DELETE(CQDelete::new);

    private final Supplier<CQWorker> workerSupplier;

    private CQCommandType(Supplier<CQWorker> workerSupplier) {
        this.workerSupplier = workerSupplier;
    }

    public CompletionStage<QueryResponse> perform(AdvancedCache<?, ?> cache, QueryDefinition queryDefinition, UUID queryId, int docIndex, BitSet segments) {
        CQWorker worker = this.workerSupplier.get();
        worker.initialize(cache.withStorageMediaType(), queryDefinition, queryId, docIndex);
        return worker.perform(segments);
    }
}

