/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=4221)
public final class QueryDefinition {
    @ProtoField(value=1)
    final String queryString;
    @ProtoField(value=2)
    final IckleParsingResult.StatementType statementType;
    @ProtoField(value=3)
    int maxResults;
    @ProtoField(value=4)
    int firstResult = 0;
    @ProtoField(value=5)
    int hitCountAccuracy = -1;
    @ProtoField(value=6)
    long timeout = -1L;
    @ProtoField(value=7)
    boolean scoreRequired = false;
    private final SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider;
    private final Map<String, Object> namedParameters = new HashMap<String, Object>();
    private final int originalMaxResults;
    private SearchQueryBuilder searchQueryBuilder;

    public QueryDefinition(String queryString, IckleParsingResult.StatementType statementType, SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>> queryEngineProvider, int originalMaxResults) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString cannot be null");
        }
        if (statementType == null) {
            throw new IllegalArgumentException("statementType cannot be null");
        }
        if (queryEngineProvider == null) {
            throw new IllegalArgumentException("queryEngineProvider cannot be null");
        }
        this.queryString = queryString;
        this.statementType = statementType;
        this.queryEngineProvider = queryEngineProvider;
        this.maxResults = originalMaxResults;
        this.originalMaxResults = originalMaxResults;
    }

    public QueryDefinition(String queryString, IckleParsingResult.StatementType statementType, SearchQueryBuilder searchQueryBuilder, int originalMaxResults) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString cannot be null");
        }
        if (statementType == null) {
            throw new IllegalArgumentException("statementType cannot be null");
        }
        if (searchQueryBuilder == null) {
            throw new IllegalArgumentException("searchQueryBuilder cannot be null");
        }
        this.searchQueryBuilder = searchQueryBuilder;
        this.queryString = queryString;
        this.statementType = statementType;
        this.queryEngineProvider = null;
        this.maxResults = originalMaxResults;
        this.originalMaxResults = originalMaxResults;
    }

    @ProtoFactory
    static QueryDefinition protoFactory(String queryString, IckleParsingResult.StatementType statementType, int maxResults, int firstResult, int hitCountAccuracy, long timeout, boolean scoreRequired, MarshallableObject<SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>>> wrappedQueryEngineProvider, MarshallableMap<String, Object> wrappedNamedParameters) {
        QueryDefinition queryDefinition = new QueryDefinition(queryString, statementType, (SerializableFunction)MarshallableObject.unwrap(wrappedQueryEngineProvider), maxResults);
        queryDefinition.setFirstResult(firstResult);
        queryDefinition.setHitCountAccuracy(hitCountAccuracy);
        queryDefinition.timeout = timeout;
        queryDefinition.scoreRequired = scoreRequired;
        queryDefinition.setNamedParameters(MarshallableMap.unwrap(wrappedNamedParameters));
        return queryDefinition;
    }

    @ProtoField(number=8, name="queryEngineProvider")
    MarshallableObject<SerializableFunction<AdvancedCache<?, ?>, QueryEngine<?>>> getWrappedQueryEngineProvider() {
        return MarshallableObject.create(this.queryEngineProvider);
    }

    @ProtoField(value=9)
    MarshallableMap<String, Object> getWrappedNamedParameters() {
        return MarshallableMap.create(this.namedParameters);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public IckleParsingResult.StatementType getStatementType() {
        return this.statementType;
    }

    private QueryEngine<?> getQueryEngine(AdvancedCache<?, ?> cache) {
        if (this.queryEngineProvider == null) {
            throw new IllegalStateException("No query engine provider specified");
        }
        QueryEngine queryEngine = (QueryEngine)((Object)this.queryEngineProvider.apply(cache));
        if (queryEngine == null) {
            throw new IllegalStateException("The query engine provider could not locate a suitable query engine");
        }
        return queryEngine;
    }

    public void initialize(AdvancedCache<?, ?> cache) {
        if (this.searchQueryBuilder == null) {
            QueryEngine<?> queryEngine = this.getQueryEngine(cache);
            this.searchQueryBuilder = queryEngine.buildSearchQuery(this.queryString, this.namedParameters);
            if (this.hitCountAccuracy != -1) {
                this.searchQueryBuilder.hitCountAccuracy(this.hitCountAccuracy);
            }
            if (this.timeout > 0L) {
                this.searchQueryBuilder.failAfter(this.timeout, TimeUnit.NANOSECONDS);
            }
        }
    }

    public SearchQueryBuilder getSearchQueryBuilder() {
        if (this.searchQueryBuilder == null) {
            throw new IllegalStateException("The QueryDefinition has not been initialized, make sure to call initialize(...) first");
        }
        return this.searchQueryBuilder;
    }

    public boolean isCustomMaxResults() {
        return this.maxResults != this.originalMaxResults;
    }

    public int getMaxResults() {
        return this.maxResults == -1 ? Integer.MAX_VALUE - this.getFirstResult() : this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setHitCountAccuracy(int hitCountAccuracy) {
        this.hitCountAccuracy = hitCountAccuracy;
        if (this.hitCountAccuracy != -1 && this.searchQueryBuilder != null) {
            this.searchQueryBuilder.hitCountAccuracy(hitCountAccuracy);
        }
    }

    public void setNamedParameters(Map<String, Object> params) {
        if (params == null) {
            this.namedParameters.clear();
        } else {
            this.namedParameters.putAll(params);
        }
    }

    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
        if (this.timeout > 0L && this.searchQueryBuilder != null) {
            this.searchQueryBuilder.failAfter(this.timeout, TimeUnit.NANOSECONDS);
        }
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.getSearchQueryBuilder().failAfter(timeout, timeUnit);
    }

    public void scoreRequired() {
        this.scoreRequired = true;
    }

    public boolean isScoreRequired() {
        return this.scoreRequired;
    }
}

