/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.infinispan.AdvancedCache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.impl.EntityLoaded;
import org.infinispan.query.impl.QueryKeyConverter;

public final class MetadataEntityLoader<E>
implements PojoSelectionEntityLoader<EntityLoaded<E>> {
    private final AdvancedCache<?, E> cache;
    private final LocalQueryStatistics queryStatistics;
    private final QueryKeyConverter queryKeyConverter;

    MetadataEntityLoader(AdvancedCache<?, E> cache, LocalQueryStatistics queryStatistics) {
        this.cache = cache;
        this.queryStatistics = queryStatistics;
        this.queryKeyConverter = new QueryKeyConverter(cache);
    }

    public List<EntityLoaded<E>> loadBlocking(List<?> identifiers, Deadline deadline) {
        if (identifiers.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Object> keys = this.queryKeyConverter.convertKeys(identifiers);
        long start = this.queryStatistics.isEnabled() ? System.nanoTime() : 0L;
        Map entries = this.cache.getAllCacheEntries(keys);
        Map values = this.queryKeyConverter.convertEntries(entries);
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.entityLoaded(System.nanoTime() - start);
        }
        ArrayList<EntityLoaded<EntityLoaded<Object>>> result = new ArrayList<EntityLoaded<EntityLoaded<Object>>>(keys.size());
        for (Object key : keys) {
            CacheEntry cacheEntry = (CacheEntry)values.get(key);
            if (cacheEntry != null) {
                result.add(new EntityLoaded<Object>(cacheEntry.getValue(), cacheEntry.getMetadata()));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataEntityLoader that = (MetadataEntityLoader)o;
        return Objects.equals(this.cache, that.cache) && Objects.equals(this.queryStatistics, that.queryStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.cache, this.queryStatistics);
    }
}

