/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.metamodel;

import java.util.Optional;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;

public class ValueFieldMetamodel
implements JsonSerialization {
    private final boolean multiValued;
    private final boolean multiValuedInRoot;
    private final Class<?> type;
    private final Class<?> projectionType;
    private final Class<?> argumentType;
    private final boolean searchable;
    private final boolean projectable;
    private final boolean sortable;
    private final boolean aggregable;
    private final Optional<String> analyzer;
    private final Optional<String> normalizer;

    public ValueFieldMetamodel(boolean multiValued, boolean multiValuedInRoot, IndexValueFieldTypeDescriptor type) {
        this.multiValued = multiValued;
        this.multiValuedInRoot = multiValuedInRoot;
        this.type = type.valueClass();
        this.projectionType = type.projectedValueClass();
        this.argumentType = type.dslArgumentClass();
        this.searchable = type.searchable();
        this.sortable = type.sortable();
        this.projectable = type.projectable();
        this.aggregable = type.aggregable();
        this.analyzer = type.analyzerName();
        this.normalizer = type.normalizerName();
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isMultiValuedInRoot() {
        return this.multiValuedInRoot;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getProjectionType() {
        return this.projectionType;
    }

    public Class<?> getArgumentType() {
        return this.argumentType;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isProjectable() {
        return this.projectable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isAggregable() {
        return this.aggregable;
    }

    public Optional<String> getAnalyzer() {
        return this.analyzer;
    }

    public Optional<String> getNormalizer() {
        return this.normalizer;
    }

    public Json toJson() {
        Json object = Json.object((Object[])new Object[]{"multi-valued", this.multiValued, "multi-valued-in-root", this.multiValuedInRoot});
        object.set("type", this.type);
        object.set("projection-type", this.projectionType);
        object.set("argument-type", this.argumentType);
        object.set("searchable", (Object)this.searchable);
        object.set("sortable", (Object)this.sortable);
        object.set("projectable", (Object)this.projectable);
        object.set("aggregable", (Object)this.aggregable);
        if (this.analyzer.isPresent()) {
            object.set("analyzer", (Object)this.analyzer.get());
        }
        if (this.normalizer.isPresent()) {
            object.set("normalizer", (Object)this.normalizer.get());
        }
        return object;
    }
}

