/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.common.timing.spi.Deadline;
import org.infinispan.AdvancedCache;
import org.infinispan.encoding.DataConversion;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.impl.QueryResultLoader;
import org.infinispan.search.mapper.common.EntityReference;

public final class EntityLoader<E>
implements QueryResultLoader<E> {
    private final LocalQueryStatistics queryStatistics;
    private final AdvancedCache<?, E> cache;
    private final KeyTransformationHandler keyTransformationHandler;
    private final DataConversion keyDataConversion;

    public EntityLoader(LocalQueryStatistics queryStatistics, AdvancedCache<?, E> cache, KeyTransformationHandler keyTransformationHandler) {
        this.cache = cache;
        this.keyTransformationHandler = keyTransformationHandler;
        this.keyDataConversion = cache.getKeyDataConversion();
        this.queryStatistics = queryStatistics;
    }

    private Object decodeKey(EntityReference entityReference) {
        return this.keyDataConversion.fromStorage(entityReference.key());
    }

    @Override
    public E loadBlocking(EntityReference entityReference) {
        return (E)this.cache.get(this.decodeKey(entityReference));
    }

    public List<E> loadBlocking(List<EntityReference> entityReferences, Deadline deadline) {
        if (entityReferences.isEmpty()) {
            return Collections.emptyList();
        }
        int entitiesSize = entityReferences.size();
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(entitiesSize);
        for (EntityReference entityReference : entityReferences) {
            keys.add(this.decodeKey(entityReference));
        }
        long start = 0L;
        if (this.queryStatistics.isEnabled()) {
            start = System.nanoTime();
        }
        Map values = this.cache.getAll(keys);
        if (this.queryStatistics.isEnabled()) {
            this.queryStatistics.entityLoaded(System.nanoTime() - start);
        }
        ArrayList result = new ArrayList(entityReferences.size());
        for (Object e : keys) {
            result.add(values.get(e));
        }
        return result;
    }
}

