/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.lucene.search.query.LuceneSearchQuery;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.util.common.SearchException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.query.SearchTimeoutException;
import org.infinispan.query.core.impl.PartitionHandlingSupport;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.embedded.impl.SearchQueryBuilder;
import org.infinispan.query.impl.IndexedQuery;
import org.infinispan.query.impl.QueryDefinition;

public class IndexedQueryImpl<E>
implements IndexedQuery<E> {
    protected final AdvancedCache<?, ?> cache;
    protected final PartitionHandlingSupport partitionHandlingSupport;
    protected QueryDefinition queryDefinition;
    protected LocalQueryStatistics queryStatistics;

    public IndexedQueryImpl(QueryDefinition queryDefinition, AdvancedCache<?, ?> cache, LocalQueryStatistics queryStatistics) {
        this.queryDefinition = queryDefinition;
        this.cache = cache;
        this.partitionHandlingSupport = new PartitionHandlingSupport(cache);
        this.queryStatistics = queryStatistics;
    }

    public IndexedQueryImpl(String queryString, SearchQueryBuilder searchQuery, AdvancedCache<?, ?> cache, LocalQueryStatistics queryStatistics) {
        this(new QueryDefinition(queryString, searchQuery), cache, queryStatistics);
    }

    @Override
    public int getResultSize() {
        this.partitionHandlingSupport.checkCacheAvailable();
        return Math.toIntExact(this.queryDefinition.getSearchQuery().build().fetchTotalHitCount());
    }

    @Override
    public IndexedQuery<E> firstResult(int firstResult) {
        this.queryDefinition.setFirstResult(firstResult);
        return this;
    }

    @Override
    public IndexedQuery<E> maxResults(int maxResults) {
        this.queryDefinition.setMaxResults(maxResults);
        return this;
    }

    private void recordQuery(String q, long took) {
        this.queryStatistics.localIndexedQueryExecuted(q, took);
    }

    @Override
    public CloseableIterator<E> iterator() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQuery().build();
        long start = 0L;
        if (this.queryStatistics.isEnabled()) {
            start = System.nanoTime();
        }
        List<E> queryHits = this.fetchHits((SearchQuery<?>)searchQuery);
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return new FilterIterator(queryHits.iterator(), Objects::nonNull);
    }

    @Override
    public List<E> list() throws SearchException {
        this.partitionHandlingSupport.checkCacheAvailable();
        LuceneSearchQuery<?> searchQuery = this.queryDefinition.getSearchQuery().build();
        long start = 0L;
        if (this.queryStatistics.isEnabled()) {
            start = System.nanoTime();
        }
        List<E> searchResult = this.fetchHits((SearchQuery<?>)searchQuery);
        if (this.queryStatistics.isEnabled()) {
            this.recordQuery(this.queryDefinition.getQueryString(), System.nanoTime() - start);
        }
        return searchResult;
    }

    private List<E> fetchHits(SearchQuery<?> searchQuery) {
        try {
            return searchQuery.fetchHits(Integer.valueOf(this.queryDefinition.getFirstResult()), Integer.valueOf(this.queryDefinition.getMaxResults()));
        }
        catch (org.hibernate.search.util.common.SearchTimeoutException timeoutException) {
            throw new SearchTimeoutException();
        }
    }

    @Override
    public IndexedQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.queryDefinition.failAfter(timeout, timeUnit);
        return this;
    }
}

