/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LuceneBooleanQueryExternalizer
extends AbstractExternalizer<BooleanQuery> {
    private static final Log log = (Log)LogFactory.getLog(LuceneBooleanQueryExternalizer.class, Log.class);

    public Set<Class<? extends BooleanQuery>> getTypeClasses() {
        return Collections.singleton(BooleanQuery.class);
    }

    public BooleanQuery readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean disableCoord = input.readBoolean();
        float boost = input.readFloat();
        int minimumNumberShouldMatch = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        int numberOfClauses = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        BooleanQuery.Builder unserialized = new BooleanQuery.Builder().setDisableCoord(disableCoord).setMinimumNumberShouldMatch(minimumNumberShouldMatch);
        LuceneBooleanQueryExternalizer.assureNumberOfClausesLimit(numberOfClauses);
        for (int i = 0; i < numberOfClauses; ++i) {
            this.appendReadClause(input, unserialized);
        }
        BooleanQuery booleanQuery = unserialized.build();
        booleanQuery.setBoost(boost);
        return booleanQuery;
    }

    private void appendReadClause(ObjectInput input, BooleanQuery.Builder builder) throws IOException, ClassNotFoundException {
        BooleanClause.Occur occur = BooleanClause.Occur.valueOf((String)input.readUTF());
        Query q = (Query)input.readObject();
        BooleanClause clause = new BooleanClause(q, occur);
        builder.add(clause);
    }

    private void writeClause(ObjectOutput output, BooleanClause booleanClause) throws IOException {
        output.writeUTF(booleanClause.getOccur().name());
        output.writeObject(booleanClause.getQuery());
    }

    public void writeObject(ObjectOutput output, BooleanQuery query) throws IOException {
        output.writeBoolean(query.isCoordDisabled());
        output.writeFloat(query.getBoost());
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)query.getMinimumNumberShouldMatch());
        List booleanClauses = query.clauses();
        int numberOfClauses = booleanClauses.size();
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)numberOfClauses);
        for (BooleanClause booleanClause : booleanClauses) {
            this.writeClause(output, booleanClause);
        }
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_QUERY_BOOLEAN;
    }

    private static void assureNumberOfClausesLimit(int numberOfClauses) {
        if (numberOfClauses > BooleanQuery.getMaxClauseCount()) {
            log.overridingBooleanQueryMaxClauseCount(numberOfClauses);
            BooleanQuery.setMaxClauseCount((int)numberOfClauses);
        }
    }
}

