/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.BitSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Factory;

public class SegmentFilterFactory {
    public static final String SEGMENT_FILTER_NAME = "segmentFilter";
    public static final String SEGMENT_PARAMETERS_NAME = "segments";
    private BitSet segments;

    @Factory
    public Query create() {
        if (this.segments == null) {
            throw new IllegalStateException("Cannot filter, missing segments parameters");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        this.segments.stream().forEach(seg -> builder.add((Query)new TermQuery(new Term("__segmentId", String.valueOf(seg))), BooleanClause.Occur.SHOULD));
        return builder.build();
    }

    public void setSegments(BitSet segments) {
        this.segments = segments;
    }
}

