/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.query.ClosableIteratorWithCount;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

public abstract class BaseQuery<T>
implements Query<T> {
    private static final Log log = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)BaseQuery.class.getName());
    protected final QueryFactory queryFactory;
    protected final String queryString;
    private final boolean paramsDefined;
    protected Map<String, Object> namedParameters;
    protected final String[] projection;
    protected int startOffset;
    protected int maxResults;
    protected Integer hitCountAccuracy;
    protected boolean local;
    protected boolean scoreRequired;
    protected long timeout = -1L;

    protected BaseQuery(QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, boolean local) {
        this.paramsDefined = true;
        this.queryFactory = queryFactory;
        this.queryString = queryString;
        this.namedParameters = namedParameters;
        this.projection = projection != null && projection.length > 0 ? projection : null;
        this.startOffset = startOffset < 0L ? 0 : (int)startOffset;
        this.maxResults = maxResults;
        this.local = local;
    }

    protected BaseQuery(QueryFactory queryFactory, String queryString) {
        this.paramsDefined = false;
        this.queryFactory = queryFactory;
        this.queryString = queryString;
        this.projection = null;
        this.startOffset = 0;
        this.maxResults = -1;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, Object> getParameters() {
        return this.namedParameters != null ? Collections.unmodifiableMap(this.namedParameters) : null;
    }

    @Override
    public Query<T> setParameter(String paramName, Object paramValue) {
        if (paramName == null || paramName.isEmpty()) {
            throw log.parameterNameCannotBeNulOrEmpty();
        }
        if (this.paramsDefined) {
            if (this.namedParameters == null) {
                throw log.queryDoesNotHaveParameters();
            }
            if (!this.namedParameters.containsKey(paramName)) {
                throw log.parameterNotFound(paramName);
            }
        } else if (this.namedParameters == null) {
            this.namedParameters = new HashMap<String, Object>(5);
        }
        this.namedParameters.put(paramName, paramValue);
        this.resetQuery();
        return this;
    }

    @Override
    public Query<T> setParameters(Map<String, Object> paramValues) {
        if (paramValues == null) {
            throw log.argumentCannotBeNull("paramValues");
        }
        if (this.paramsDefined) {
            if (this.namedParameters == null) {
                throw log.queryDoesNotHaveParameters();
            }
            ArrayList<String> unknownParams = null;
            for (String paramName : paramValues.keySet()) {
                if (paramName == null || paramName.isEmpty()) {
                    throw log.parameterNameCannotBeNulOrEmpty();
                }
                if (this.namedParameters.containsKey(paramName)) continue;
                if (unknownParams == null) {
                    unknownParams = new ArrayList<String>();
                }
                unknownParams.add(paramName);
            }
            if (unknownParams != null) {
                throw log.parametersNotFound(((Object)unknownParams).toString());
            }
        } else if (this.namedParameters == null) {
            this.namedParameters = new HashMap<String, Object>(5);
        }
        this.namedParameters.putAll(paramValues);
        this.resetQuery();
        return this;
    }

    public abstract void resetQuery();

    public void validateNamedParameters() {
        if (this.namedParameters != null) {
            for (Map.Entry<String, Object> e : this.namedParameters.entrySet()) {
                if (e.getValue() != null) continue;
                throw log.queryParameterNotSet(e.getKey());
            }
        }
    }

    @Override
    public String[] getProjection() {
        return this.projection;
    }

    public boolean hasProjections() {
        return this.projection != null;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public Query<T> startOffset(long startOffset) {
        this.startOffset = (int)startOffset;
        this.resetQuery();
        return this;
    }

    @Override
    public Query<T> maxResults(int maxResults) {
        this.maxResults = maxResults;
        this.resetQuery();
        return this;
    }

    public Integer hitCountAccuracy() {
        return this.hitCountAccuracy;
    }

    @Override
    public Query<T> hitCountAccuracy(int hitCountAccuracy) {
        this.hitCountAccuracy = hitCountAccuracy;
        return this;
    }

    public Query<T> local(boolean local) {
        this.local = local;
        this.resetQuery();
        return this;
    }

    public boolean isLocal() {
        return this.local;
    }

    public Query<T> scoreRequired(boolean scoreRequired) {
        this.scoreRequired = scoreRequired;
        return this;
    }

    @Override
    public Query<T> timeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
        return this;
    }

    public <K> ClosableIteratorWithCount<EntityEntry<K, T>> entryIterator(boolean withMetadata) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    public int executeStatement() {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

