/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.tests;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.api.query.Query;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.core.Search;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.QueryStatistics;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.core.stats.SearchStatisticsSnapshot;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.core.tests.QueryCoreTest")
public class QueryCoreTest
extends SingleCacheManagerTest {
    private Cache<String, Person> cacheWithStats;

    protected EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(false);
        ConfigurationBuilder stat = this.getDefaultStandaloneCacheConfig(false);
        stat.statistics().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((boolean)false);
        cm.defineConfiguration("test", c.build());
        cm.defineConfiguration("stat", stat.build());
        this.cache = cm.getCache("test");
        this.cacheWithStats = cm.getCache("stat");
        return cm;
    }

    public void testQuery() {
        Person spidey = new Person();
        spidey.setName("Hombre");
        spidey.setSurname("Ara\u00f1a");
        this.cache.put((Object)"key1", (Object)spidey);
        Person superMujer = new Person();
        superMujer.setName("Super");
        superMujer.setSurname("Woman");
        this.cache.put((Object)"key2", (Object)superMujer);
        AssertJUnit.assertEquals((int)2, (int)this.cache.size());
        Query query = this.cache.query("from " + Person.class.getName() + " where name='Hombre'");
        List results = query.execute().list();
        AssertJUnit.assertEquals((String)"Ara\u00f1a", (String)((Person)results.get(0)).getSurname());
    }

    @Test
    public void testStats() {
        String q = String.format("FROM %s", Person.class.getName());
        Query query = this.cache.query(q);
        query.execute().list();
        SearchStatistics searchStatistics = Search.getSearchStatistics((Cache)this.cache);
        QueryStatistics queryStatistics = searchStatistics.getQueryStatistics();
        IndexStatistics indexStatistics = searchStatistics.getIndexStatistics();
        AssertJUnit.assertTrue((boolean)((Map)FunctionalTestUtils.await((CompletionStage)indexStatistics.computeIndexInfos())).isEmpty());
        AssertJUnit.assertTrue((boolean)((SearchStatisticsSnapshot)FunctionalTestUtils.await((CompletionStage)Search.getClusteredSearchStatistics((Cache)this.cache))).getIndexStatistics().indexInfos().isEmpty());
        AssertJUnit.assertEquals((long)0L, (long)queryStatistics.getNonIndexedQueryCount());
        query = this.cacheWithStats.query(String.format("FROM %s", Person.class.getName()));
        query.execute().list();
        searchStatistics = Search.getSearchStatistics(this.cacheWithStats);
        queryStatistics = searchStatistics.getQueryStatistics();
        indexStatistics = searchStatistics.getIndexStatistics();
        AssertJUnit.assertTrue((boolean)((Map)FunctionalTestUtils.await((CompletionStage)indexStatistics.computeIndexInfos())).isEmpty());
        AssertJUnit.assertTrue((boolean)((Map)FunctionalTestUtils.await(Search.getClusteredSearchStatistics(this.cacheWithStats).thenCompose(s -> s.getIndexStatistics().computeIndexInfos()))).isEmpty());
        AssertJUnit.assertEquals((long)1L, (long)queryStatistics.getNonIndexedQueryCount());
        AssertJUnit.assertTrue((queryStatistics.getNonIndexedQueryAvgTime() > 0.0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((queryStatistics.getNonIndexedQueryMaxTime() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((queryStatistics.getNonIndexedQueryTotalTime() > 0L ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)q, (String)queryStatistics.getSlowestNonIndexedQuery());
        Assertions.assertThat((int)indexStatistics.genericIndexingFailures()).isZero();
        Assertions.assertThat((int)indexStatistics.entityIndexingFailures()).isZero();
    }

    private static class Person {
        private String _name;
        private String _surname;

        private Person() {
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getSurname() {
            return this._surname;
        }

        public void setSurname(String surname) {
            this._surname = surname;
        }

        public String toString() {
            return "Person{name='" + this._name + "', surname='" + this._surname + "'}";
        }
    }
}

