/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.core.impl.LocalQueryStatisticsTest")
public class LocalQueryStatisticsTest {
    public static final int THREADS = 10;
    public static final int MAX_SAMPLE_LATENCY = 10000;
    public static final int SAMPLE_SIZE = 1000000;
    private static final Random RANDOM = new Random(0L);
    private final Map<Query, Long> timePerQuery = LongStream.rangeClosed(1L, 1000000L).boxed().collect(Collectors.toMap(Query::random, l -> RANDOM.nextInt(10000)));

    @Test
    public void testRecord() throws Exception {
        LocalQueryStatistics statistics = new LocalQueryStatistics();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        LinkedBlockingDeque<Map.Entry<Query, Long>> data = new LinkedBlockingDeque<Map.Entry<Query, Long>>(this.timePerQuery.entrySet());
        CountDownLatch countDownLatch = new CountDownLatch(1);
        for (int i = 1; i <= 10; ++i) {
            executorService.submit(() -> {
                try {
                    countDownLatch.await();
                    while (!data.isEmpty()) {
                        Map.Entry take = (Map.Entry)data.poll(1L, TimeUnit.SECONDS);
                        if (take == null) continue;
                        Query q = (Query)take.getKey();
                        Long time = (Long)take.getValue();
                        switch (q.getType().ordinal()) {
                            case 0: {
                                statistics.localIndexedQueryExecuted(q.str, time.longValue());
                                break;
                            }
                            case 2: {
                                statistics.hybridQueryExecuted(q.str, time.longValue());
                                break;
                            }
                            case 1: {
                                statistics.distributedIndexedQueryExecuted(q.str, time.longValue());
                                break;
                            }
                            case 3: {
                                statistics.nonIndexedQueryExecuted(q.str, time.longValue());
                            }
                        }
                        statistics.entityLoaded(time / 2L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        countDownLatch.countDown();
        executorService.shutdown();
        executorService.awaitTermination(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((long)this.count(QueryType.INDEX_LOCAL), (long)statistics.getLocalIndexedQueryCount());
        AssertJUnit.assertEquals((Object)this.avg(QueryType.INDEX_LOCAL), (Object)statistics.getLocalIndexedQueryAvgTime());
        AssertJUnit.assertEquals((long)this.max(QueryType.INDEX_LOCAL), (long)statistics.getLocalIndexedQueryMaxTime());
        AssertJUnit.assertEquals((String)this.slowestQuery(QueryType.INDEX_LOCAL), (String)statistics.getSlowestLocalIndexedQuery());
        AssertJUnit.assertEquals((long)this.count(QueryType.INDEX_DISTRIBUTED), (long)statistics.getDistributedIndexedQueryCount());
        AssertJUnit.assertEquals((Object)this.avg(QueryType.INDEX_DISTRIBUTED), (Object)statistics.getDistributedIndexedQueryAvgTime());
        AssertJUnit.assertEquals((long)this.max(QueryType.INDEX_DISTRIBUTED), (long)statistics.getLocalIndexedQueryMaxTime());
        AssertJUnit.assertEquals((String)this.slowestQuery(QueryType.INDEX_DISTRIBUTED), (String)statistics.getSlowestDistributedIndexedQuery());
        AssertJUnit.assertEquals((long)this.count(QueryType.HYBRID), (long)statistics.getHybridQueryCount());
        AssertJUnit.assertEquals((Object)this.avg(QueryType.HYBRID), (Object)statistics.getHybridQueryAvgTime());
        AssertJUnit.assertEquals((long)this.max(QueryType.HYBRID), (long)statistics.getHybridQueryMaxTime());
        AssertJUnit.assertEquals((String)this.slowestQuery(QueryType.HYBRID), (String)statistics.getSlowestHybridQuery());
        AssertJUnit.assertEquals((long)this.count(QueryType.NON_INDEXED), (long)statistics.getNonIndexedQueryCount());
        AssertJUnit.assertEquals((Object)this.avg(QueryType.NON_INDEXED), (Object)statistics.getNonIndexedQueryAvgTime());
        AssertJUnit.assertEquals((long)this.max(QueryType.NON_INDEXED), (long)statistics.getNonIndexedQueryMaxTime());
        AssertJUnit.assertEquals((String)this.slowestQuery(QueryType.NON_INDEXED), (String)statistics.getSlowestNonIndexedQuery());
        AssertJUnit.assertEquals((long)1000000L, (long)statistics.getLoadCount());
    }

    private long count(QueryType queryType) {
        return this.timePerQuery.entrySet().stream().filter(e -> ((Query)e.getKey()).getType().equals((Object)queryType)).count();
    }

    private double avg(QueryType queryType) {
        return this.timePerQuery.entrySet().stream().filter(e -> ((Query)e.getKey()).getType().equals((Object)queryType)).map(Map.Entry::getValue).collect(Collectors.averagingLong(l -> l));
    }

    private long max(QueryType queryType) {
        return this.timePerQuery.entrySet().stream().filter(e -> ((Query)e.getKey()).getType().equals((Object)queryType)).map(Map.Entry::getValue).max(Long::compareTo).orElse(-1L);
    }

    private String slowestQuery(QueryType queryType) {
        return this.timePerQuery.entrySet().stream().filter(e -> ((Query)e.getKey()).getType().equals((Object)queryType)).reduce((e1, e2) -> ((Long)e1.getValue()).compareTo((Long)e2.getValue()) >= 0 ? e1 : e2).map(e -> ((Query)e.getKey()).str).orElse(null);
    }

    static enum QueryType {
        INDEX_LOCAL,
        INDEX_DISTRIBUTED,
        HYBRID,
        NON_INDEXED;

    }

    static class Query {
        private final QueryType type;
        private final String str;

        public Query(QueryType type, String str) {
            this.type = type;
            this.str = str;
        }

        public QueryType getType() {
            return this.type;
        }

        public String getStr() {
            return this.str;
        }

        public static Query random(long q) {
            QueryType[] values = QueryType.values();
            return new Query(values[RANDOM.nextInt(values.length)], String.valueOf(q));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Query query = (Query)o;
            if (this.type != query.type) {
                return false;
            }
            return this.str.equals(query.str);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.str.hashCode();
            return result;
        }

        public String toString() {
            return "Query{type=" + String.valueOf((Object)this.type) + ", q='" + this.str + "'}";
        }
    }
}

