/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import jakarta.transaction.Transaction;
import java.lang.invoke.MethodHandles;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CacheBackpressureFullException;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.partitionhandling.AvailabilityException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=14001, max=14500)
public interface Log
extends BasicLogger {
    public static final String LOG_ROOT = "org.infinispan.";
    public static final Log CONTAINER = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)"org.infinispan.CONTAINER");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Could not locate key class %s", id=14001)
    public void keyClassNotFound(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot instantiate Transformer class %s", id=14002)
    public void couldNotInstantiateTransformerClass(Class<?> var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Indexed type '%1$s' is using a default Transformer. This is slow! Register a custom implementation using @Transformable", id=14009)
    public void typeIsUsingDefaultTransformer(Class<?> var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reindexed %1$d entities in %2$d ms", id=14014)
    public void indexingEntitiesCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="%1$d documents indexed in %2$d ms", id=14015)
    public void indexingDocumentsCompleted(long var1, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Purging instances of '%s' from the index", id=14016)
    public void purgingIndex(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Flushing index '%s'", id=14017)
    public void flushingIndex(String var1);

    @Message(value="Cannot run Lucene queries on a cache '%s' that does not have indexing enabled", id=14019)
    public IllegalStateException cannotRunLuceneQueriesIfNotIndexed(String var1);

    @Message(value="Queries containing grouping and aggregation functions must use projections.", id=14021)
    public ParsingException groupingAndAggregationQueriesMustUseProjections();

    @Message(value="Cannot have aggregate functions in GROUP BY clause", id=14022)
    public IllegalStateException cannotHaveAggregationsInGroupByClause();

    @Message(value="Using the multi-valued property path '%s' in the GROUP BY clause is not currently supported", id=14023)
    public ParsingException multivaluedPropertyCannotBeUsedInGroupBy(String var1);

    @Message(value="The property path '%s' cannot be used in the ORDER BY clause because it is multi-valued", id=14024)
    public ParsingException multivaluedPropertyCannotBeUsedInOrderBy(String var1);

    @Message(value="The query must not use grouping or aggregation", id=14025)
    public IllegalStateException queryMustNotUseGroupingOrAggregation();

    @Message(value="The expression '%s' must be part of an aggregate function or it should be included in the GROUP BY clause", id=14026)
    public ParsingException expressionMustBePartOfAggregateFunctionOrShouldBeIncludedInGroupByClause(String var1);

    @Message(value="The property path '%s' cannot be projected because it is multi-valued", id=14027)
    public ParsingException multivaluedPropertyCannotBeProjected(String var1);

    @Message(value="Unable to resume suspended transaction %s", id=14033)
    public CacheException unableToResumeSuspendedTx(Transaction var1, @Cause Throwable var2);

    @Message(value="Unable to suspend transaction", id=14034)
    public CacheException unableToSuspendTx(@Cause Throwable var1);

    @Message(value="Prefix, wildcard or regexp queries cannot be fuzzy: %s", id=14036)
    public ParsingException getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(String var1);

    @Message(value="Cannot execute query: cluster is operating in degraded mode and partition handling configuration doesn't allow reads and writes.", id=14042)
    public AvailabilityException partitionDegraded();

    @Message(value="Cannot find an appropriate Transformer for key type %s. Indexing only works with entries keyed on Strings, primitives, byte[], UUID, classes that have the @Transformable annotation or classes for which you have defined a suitable Transformer in the indexing configuration. Alternatively, see org.infinispan.query.spi.SearchManagerImplementor.registerKeyTransformer.", id=14043)
    public CacheException noTransformerForKey(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Setting org.apache.lucene.search.BooleanQuery.setMaxClauseCount from system property %s to value %d", id=14046)
    public void settingBooleanQueryMaxClauseCount(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring system property %s because the value %d is smaller than the current value (%d) of org.apache.lucene.search.BooleanQuery.getMaxClauseCount()", id=14047)
    public void ignoringBooleanQueryMaxClauseCount(String var1, int var2, int var3);

    @Message(value="Interrupted while waiting for completions of some batch indexing operations.", id=14050)
    public CacheException interruptedWhileWaitingForRequestCompletion(@Cause Exception var1);

    @Message(value="%1$s entities could not be indexed. See the logs for details. First failure on entity '%2$s': %3$s", id=14051)
    public String massIndexingEntityFailures(long var1, Object var3, String var4);

    @Message(value="Indexing instance of entity '%s' during mass indexing", id=14052)
    public String massIndexerIndexingInstance(String var1);

    @Message(value="Trying to execute query `%1$s`, but no type is indexed on cache.", id=14054)
    public CacheException noTypeIsIndexed(String var1);

    @Message(value="Cannot index entry since the search mapping failed to initialize.", id=14055)
    public CacheException searchMappingUnavailable();

    @Message(value="Only DELETE statements are supported by executeStatement", id=14056)
    public CacheException unsupportedStatement();

    @Message(value="DELETE statements cannot use paging (firstResult/maxResults)", id=14057)
    public CacheException deleteStatementsCannotUsePaging();

    @Message(value="Projections are not supported with entryIterator()", id=14058)
    public CacheException entryIteratorDoesNotAllowProjections();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The indexing engine is restarting, index updates will be skipped for the current data changes.", id=14059)
    public void mappingIsRestarting();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="We're getting some errors from Hibernate Search or Lucene while we compute the index count/size for statistics. There is probably a concurrent reindexing ongoing.", id=14060)
    public void concurrentReindexingOnGetStatistics(@Cause Throwable var1);

    @Message(value="Failed to load declared indexed class '%s'", id=14061)
    public CacheConfigurationException cannotLoadIndexedClass(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Search engine is reloaded before the reindexing.", id=14062)
    public void preIndexingReloading();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Reindexing starting.", id=14063)
    public void indexingStarting();

    @Message(value="Multiple knn predicates are not supported at the moment.", id=14064)
    public ParsingException multipleKnnPredicates();

    @Message(value="Boolean predicates containing knn predicates are not supported at the moment.", id=14065)
    public ParsingException booleanKnnPredicates();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to purge index for segments %s", id=14066)
    public void failedToPurgeIndexForSegments(@Cause Throwable var1, IntSet var2);

    @Message(value="Hibernate Search updates are not keeping up. Look into increasing index writer queue and/or thread pool sizes.", id=14067)
    public CacheBackpressureFullException hibernateSearchBackpressure();
}

