/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl.continuous;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.query.api.continuous.ContinuousQuery;
import org.infinispan.query.api.continuous.ContinuousQueryListener;
import org.infinispan.query.core.impl.continuous.ContinuousQueryResult;
import org.infinispan.query.core.impl.continuous.IckleContinuousQueryCacheEventFilterConverter;
import org.infinispan.query.dsl.Query;

public final class ContinuousQueryImpl<K, V>
implements ContinuousQuery<K, V> {
    private final Cache<K, V> cache;
    private final List<EntryListener<K, V, ?>> listeners = new ArrayList();

    public ContinuousQueryImpl(Cache<K, V> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter cannot be null");
        }
        this.cache = cache;
    }

    public <C> void addContinuousQueryListener(String queryString, ContinuousQueryListener<K, C> listener) {
        this.addContinuousQueryListener(queryString, null, listener);
    }

    public <C> void addContinuousQueryListener(String queryString, Map<String, Object> namedParameters, ContinuousQueryListener<K, C> listener) {
        EntryListener entryListener = new EntryListener(listener);
        IckleContinuousQueryCacheEventFilterConverter filterConverter = new IckleContinuousQueryCacheEventFilterConverter(queryString, namedParameters, ReflectionMatcher.class);
        this.cache.addListener(entryListener, filterConverter, null);
        this.listeners.add(entryListener);
    }

    public <C> void addContinuousQueryListener(Query<?> query, ContinuousQueryListener<K, C> listener) {
        this.addContinuousQueryListener(query.getQueryString(), query.getParameters(), listener);
    }

    public void removeContinuousQueryListener(ContinuousQueryListener<K, ?> listener) {
        Iterator<EntryListener<K, V, ?>> it = this.listeners.iterator();
        while (it.hasNext()) {
            EntryListener<K, V, ?> l = it.next();
            if (l.listener != listener) continue;
            this.cache.removeListener(l);
            it.remove();
            break;
        }
    }

    public List<ContinuousQueryListener<K, ?>> getListeners() {
        ArrayList queryListeners = new ArrayList(this.listeners.size());
        for (EntryListener<K, V, ?> l : this.listeners) {
            queryListeners.add(l.listener);
        }
        return queryListeners;
    }

    public void removeAllListeners() {
        for (EntryListener<K, V, ?> l : this.listeners) {
            this.cache.removeListener(l);
        }
        this.listeners.clear();
    }

    @Listener(clustered=true, includeCurrentState=true, observation=Listener.Observation.POST)
    private static final class EntryListener<K, V, C> {
        private final ContinuousQueryListener<K, C> listener;

        EntryListener(ContinuousQueryListener<K, C> listener) {
            this.listener = listener;
        }

        @CacheEntryRemoved
        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryExpired
        public void handleEvent(CacheEntryEvent<K, ContinuousQueryResult<V>> event) {
            ContinuousQueryResult cqr = (ContinuousQueryResult)event.getValue();
            switch (cqr.getResultType()) {
                case JOINING: {
                    Object value = cqr.getValue() != null ? cqr.getValue() : cqr.getProjection();
                    this.listener.resultJoining(event.getKey(), value);
                    break;
                }
                case UPDATED: {
                    Object value = cqr.getValue() != null ? cqr.getValue() : cqr.getProjection();
                    this.listener.resultUpdated(event.getKey(), value);
                    break;
                }
                case LEAVING: {
                    this.listener.resultLeaving(event.getKey());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected result type : " + cqr.getResultType());
                }
            }
        }
    }
}

