/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.aggregation.RowGrouper;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.HybridQuery;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQuery;

public final class AggregatingQuery<T>
extends HybridQuery<T, Object[]> {
    private final int noOfGroupingColumns;
    private final FieldAccumulator[] accumulators;
    private final boolean twoPhaseAcc;

    public AggregatingQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String queryString, Map<String, Object> namedParameters, int noOfGroupingColumns, List<FieldAccumulator> accumulators, boolean twoPhaseAcc, ObjectFilter objectFilter, long startOffset, int maxResults, BaseQuery<?> baseQuery, LocalQueryStatistics queryStatistics, boolean local) {
        super(queryFactory, cache, queryString, IckleParsingResult.StatementType.SELECT, namedParameters, objectFilter, startOffset, maxResults, (Query<?>)baseQuery, queryStatistics, local);
        if (!baseQuery.hasProjections()) {
            throw new IllegalArgumentException("Base query must use projections");
        }
        if (this.projection == null) {
            throw new IllegalArgumentException("Aggregating query must use projections");
        }
        this.noOfGroupingColumns = noOfGroupingColumns;
        this.accumulators = accumulators != null ? accumulators.toArray(new FieldAccumulator[0]) : null;
        this.twoPhaseAcc = twoPhaseAcc;
    }

    @Override
    protected CloseableIterator<?> getBaseIterator() {
        RowGrouper grouper = new RowGrouper(this.noOfGroupingColumns, this.accumulators, this.twoPhaseAcc);
        try (CloseableIterator iterator = this.baseQuery.iterator();){
            iterator.forEachRemaining(arg_0 -> ((RowGrouper)grouper).addRow(arg_0));
        }
        return Closeables.iterator((Iterator)grouper.finish());
    }

    @Override
    public int executeStatement() {
        throw new UnsupportedOperationException();
    }

    public <K> CloseableIterator<Map.Entry<K, T>> entryIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "AggregatingQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", noOfGroupingColumns=" + this.noOfGroupingColumns + ", accumulators=" + Arrays.toString(this.accumulators) + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + ", baseQuery=" + this.baseQuery + '}';
    }
}

